/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.Objects;
import org.omegat.core.data.PrepareTMXEntry;

public class TMXEntry {
    public final String source;
    public final String translation;
    public final String changer;
    public final long changeDate;
    public final String creator;
    public final long creationDate;
    public final String note;
    public final boolean defaultTranslation;
    public final ExternalLinked linked;

    TMXEntry(PrepareTMXEntry from, boolean defaultTranslation, ExternalLinked linked) {
        this.source = from.source;
        this.translation = from.translation;
        this.changer = from.changer;
        this.changeDate = from.changeDate;
        this.creator = from.creator;
        this.creationDate = from.creationDate;
        this.note = from.note;
        this.defaultTranslation = defaultTranslation;
        this.linked = linked;
    }

    public boolean isTranslated() {
        return this.translation != null;
    }

    public boolean hasNote() {
        return this.note != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TMXEntry other = (TMXEntry)obj;
        if (this.changeDate / 1000L != other.changeDate / 1000L) {
            return false;
        }
        if (this.creationDate / 1000L != other.creationDate / 1000L) {
            return false;
        }
        if (!this.equalsTranslation(other)) {
            return false;
        }
        if (!Objects.equals(this.changer, other.changer)) {
            return false;
        }
        if (!Objects.equals(this.creator, other.creator)) {
            return false;
        }
        if (this.defaultTranslation != other.defaultTranslation) {
            return false;
        }
        return Objects.equals(this.source, other.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeDate / 1000L, this.creationDate / 1000L, this.translation, this.note, this.linked, this.changer, this.creator, this.defaultTranslation, this.source});
    }

    public boolean equalsTranslation(TMXEntry other) {
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this.translation, other.translation)) {
            return false;
        }
        if (!Objects.equals(this.note, other.note)) {
            return false;
        }
        return Objects.equals((Object)this.linked, (Object)other.linked);
    }

    public static enum ExternalLinked {
        xICE,
        x100PC,
        xAUTO;

    }
}

