/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.omegat.core.Core;
import org.omegat.gui.properties.FlashColorInterpolator;
import org.omegat.gui.properties.ISegmentPropertiesView;
import org.omegat.gui.properties.SegmentPropertiesArea;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DataTableStyling;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TableColumnSizer;
import org.omegat.util.gui.UIThreadsUtil;

public class SegmentPropertiesTableView
implements ISegmentPropertiesView {
    private SegmentPropertiesArea parent;
    private FlashingTable table;
    private PropertiesTableModel model;
    private int mouseoverRow = -1;
    private int mouseoverCol = -1;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SegmentPropertiesTableView.this.mouseoverCol == 2) {
                SegmentPropertiesTableView.this.parent.showContextMenu(SwingUtilities.convertPoint(SegmentPropertiesTableView.this.table, e.getPoint(), ((SegmentPropertiesTableView)SegmentPropertiesTableView.this).parent.scrollPane));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SegmentPropertiesTableView.this.updateRollover();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SegmentPropertiesTableView.this.updateRollover();
        }
    };

    @Override
    public void install(SegmentPropertiesArea parent) {
        this.parent = parent;
        this.model = new PropertiesTableModel();
        this.table = new FlashingTable(this.model);
        this.table.setForeground(parent.scrollPane.getForeground());
        this.table.setBackground(parent.scrollPane.getBackground());
        this.table.addMouseListener(parent.contextMenuListener);
        this.table.setAutoResizeMode(0);
        this.table.setGridColor(Color.WHITE);
        this.table.setFillsViewportHeight(true);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new SingleLineCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new MultilineCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new SingleLineCellRenderer());
        DataTableStyling.applyFont(this.table, Core.getMainWindow().getApplicationFont());
        TableColumnSizer.autoSize(this.table, 1, true).addColumnAdjustmentListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentPropertiesTableView.this.adjustRowHeights();
            }
        });
        this.table.addMouseListener(this.mouseAdapter);
        this.table.addMouseMotionListener(this.mouseAdapter);
        parent.scrollPane.setViewportView(this.table);
    }

    private void updateRollover() {
        Point point = this.table.getMousePosition();
        int oldRow = this.mouseoverRow;
        int oldCol = this.mouseoverCol;
        int newRow = point == null ? -1 : this.table.rowAtPoint(point);
        int newCol = point == null ? -1 : this.table.columnAtPoint(point);
        boolean doRepaint = newRow != oldRow || newCol != oldCol;
        this.mouseoverRow = newRow;
        this.mouseoverCol = newCol;
        if (doRepaint) {
            Rectangle rect = this.table.getCellRect(oldRow, 2, true);
            this.table.repaint(rect);
            rect = this.table.getCellRect(newRow, 2, true);
            this.table.repaint(rect);
        }
    }

    @Override
    public JComponent getViewComponent() {
        return this.table;
    }

    @Override
    public void update() {
        UIThreadsUtil.mustBeSwingThread();
        this.table.clearSelection();
        this.table.clearHighlight();
        this.model.fireTableDataChanged();
        this.adjustRowHeights();
    }

    private void adjustRowHeights() {
        int column1Width = this.table.getColumnModel().getColumn(1).getWidth();
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            TableCellRenderer cellRenderer = this.table.getCellRenderer(row, 1);
            Component c = this.table.prepareRenderer(cellRenderer, row, 1);
            c.setBounds(0, 0, column1Width, Integer.MAX_VALUE);
            int height = c.getPreferredSize().height;
            this.table.setRowHeight(row, height);
        }
    }

    @Override
    public void notifyUser(List<Integer> notify) {
        UIThreadsUtil.mustBeSwingThread();
        notify = this.translateIndices(notify);
        this.table.clearSelection();
        this.table.scrollRectToVisible(this.table.getCellRect(notify.get(0), notify.get(notify.size() - 1), true));
        this.table.flash(notify);
    }

    private List<Integer> translateIndices(List<Integer> indices) {
        ArrayList<Integer> result = new ArrayList<Integer>(indices.size());
        for (int i : indices) {
            result.add(i / 2);
        }
        return result;
    }

    @Override
    public String getKeyAtPoint(Point p) {
        int clickedRow = this.table.rowAtPoint(SwingUtilities.convertPoint(this.parent.scrollPane, p, this.table));
        if (clickedRow == -1) {
            return null;
        }
        return (String)this.model.getValueAt(clickedRow, 0);
    }

    private static class MultilineCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private final Border noFocusBorder = new EmptyBorder(ISegmentPropertiesView.FOCUS_BORDER.getBorderInsets(this));

        MultilineCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                Color bg = table.getBackground();
                this.setBackground(row % 2 == 0 ? bg : StaticUIUtils.getHighlightColor(bg));
                this.setForeground(table.getForeground());
            }
            EmptyBorder marginBorder = new EmptyBorder(1, column == 0 ? 5 : 1, 1, column == table.getColumnCount() - 1 ? 5 : 1);
            if (hasFocus) {
                this.setBorder(new CompoundBorder(marginBorder, ISegmentPropertiesView.FOCUS_BORDER));
            } else {
                this.setBorder(new CompoundBorder(marginBorder, this.noFocusBorder));
            }
            FlashingTable fTable = (FlashingTable)table;
            FlashColorInterpolator flasher = fTable.getFlasher();
            if (flasher != null) {
                flasher.mark();
                if (fTable.isHighlightedRow(row) && !isSelected) {
                    this.setBackground(flasher.getColor());
                }
            }
            this.setFont(table.getFont());
            this.setText(value.toString());
            return this;
        }
    }

    private static class SingleLineCellRenderer
    extends DefaultTableCellRenderer {
        private final Border noFocusBorder = new EmptyBorder(ISegmentPropertiesView.FOCUS_BORDER.getBorderInsets(this));

        private SingleLineCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!(comp instanceof JLabel)) {
                return comp;
            }
            JLabel result = (JLabel)comp;
            if (isSelected) {
                result.setBackground(table.getSelectionBackground());
                result.setForeground(table.getSelectionForeground());
            } else {
                Color bg = table.getBackground();
                result.setBackground(row % 2 == 0 ? bg : StaticUIUtils.getHighlightColor(bg));
                result.setForeground(table.getForeground());
            }
            EmptyBorder marginBorder = new EmptyBorder(1, column == 0 ? 5 : 1, 1, column == table.getColumnCount() - 1 ? 5 : 1);
            if (hasFocus) {
                result.setBorder(new CompoundBorder(marginBorder, ISegmentPropertiesView.FOCUS_BORDER));
            } else {
                result.setBorder(new CompoundBorder(marginBorder, this.noFocusBorder));
            }
            FlashingTable fTable = (FlashingTable)table;
            FlashColorInterpolator flasher = fTable.getFlasher();
            if (flasher != null) {
                flasher.mark();
                if (fTable.isHighlightedRow(row) && !isSelected) {
                    this.setBackground(flasher.getColor());
                }
            }
            result.setFont(table.getFont());
            if (value instanceof String) {
                result.setVerticalAlignment(1);
                result.setText(this.getText(value));
                result.setIcon(null);
            } else if (value instanceof Icon) {
                result.setVerticalAlignment(0);
                result.setText(null);
                result.setIcon((Icon)value);
            }
            return result;
        }

        private String getText(Object value) {
            if (Preferences.isPreference("segment_properties_show_raw_keys")) {
                return value.toString();
            }
            try {
                return OStrings.getString("SEGPROP_KEY_" + value.toString().toUpperCase());
            }
            catch (MissingResourceException ex) {
                return value.toString();
            }
        }
    }

    private static class FlashingTable
    extends JTable {
        private FlashColorInterpolator flasher;
        private List<Integer> rows;

        FlashingTable(TableModel model) {
            super(model);
        }

        public void flash(List<Integer> rows) {
            this.rows = rows;
            this.flasher = new FlashColorInterpolator();
            this.repaint();
        }

        public boolean isHighlightedRow(int index) {
            return this.rows != null && this.rows.contains(index);
        }

        public void clearHighlight() {
            this.flasher = null;
        }

        public FlashColorInterpolator getFlasher() {
            return this.flasher;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.flasher != null && this.flasher.isFlashing()) {
                this.repaint();
            }
        }
    }

    private class PropertiesTableModel
    extends AbstractTableModel {
        private PropertiesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return OStrings.getString("SEGPROP_TABLE_HEADER_KEY");
                }
                case 1: {
                    return OStrings.getString("SEGPROP_TABLE_HEADER_VALUE");
                }
                case 2: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return ((SegmentPropertiesTableView)SegmentPropertiesTableView.this).parent.properties.size() / 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || columnIndex < 0) {
                return null;
            }
            if (columnIndex == 2) {
                return rowIndex == SegmentPropertiesTableView.this.mouseoverRow && columnIndex == SegmentPropertiesTableView.this.mouseoverCol ? ISegmentPropertiesView.SETTINGS_ICON : (rowIndex == SegmentPropertiesTableView.this.mouseoverRow ? ISegmentPropertiesView.SETTINGS_ICON_INACTIVE : ISegmentPropertiesView.SETTINGS_ICON_INVISIBLE);
            }
            int realIndex = rowIndex * 2 + columnIndex;
            if (realIndex >= ((SegmentPropertiesTableView)SegmentPropertiesTableView.this).parent.properties.size()) {
                return null;
            }
            return ((SegmentPropertiesTableView)SegmentPropertiesTableView.this).parent.properties.get(rowIndex * 2 + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Icon.class;
                }
            }
            return null;
        }
    }
}

