/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.GridBagHelper;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.XMLRenderer;

public class GUI
implements CPDListener {
    private static final Object[][] rendererSets = new Object[][]{{"Text", new Renderer(){

        public String render(Iterator items) {
            return new SimpleRenderer().render(items);
        }
    }}, {"XML", new Renderer(){

        public String render(Iterator items) {
            return new XMLRenderer().render(items);
        }
    }}, {"CSV (comma)", new Renderer(){

        public String render(Iterator items) {
            return new CSVRenderer(',').render(items);
        }
    }}, {"CSV (tab)", new Renderer(){

        public String render(Iterator items) {
            return new CSVRenderer('\t').render(items);
        }
    }}};
    private static final Object[][] languageSets = new Object[][]{{"Java", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("java");
        }

        public boolean ignoreLiteralsByDefault() {
            return true;
        }

        public String[] extensions() {
            return new String[]{".java", ".class"};
        }
    }}, {"JSP", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("jsp");
        }

        public boolean ignoreLiteralsByDefault() {
            return false;
        }

        public String[] extensions() {
            return new String[]{".jsp"};
        }
    }}, {"C++", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("cpp");
        }

        public boolean ignoreLiteralsByDefault() {
            return false;
        }

        public String[] extensions() {
            return new String[]{".cpp", ".c"};
        }
    }}, {"Ruby", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("ruby");
        }

        public boolean ignoreLiteralsByDefault() {
            return false;
        }

        public String[] extensions() {
            return new String[]{".rb"};
        }
    }}, {"by extension...", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("by_extension", p);
        }

        public boolean ignoreLiteralsByDefault() {
            return false;
        }

        public String[] extensions() {
            return new String[]{""};
        }
    }}, {"PHP", new LanguageConfig(){

        public Language languageFor(LanguageFactory lf, Properties p) {
            return lf.createLanguage("php");
        }

        public boolean ignoreLiteralsByDefault() {
            return false;
        }

        public String[] extensions() {
            return new String[]{".php"};
        }
    }}};
    private static final int defaultCPDMinimumLength = 75;
    private static final Map langConfigsByLabel = new HashMap(languageSets.length);
    private static final KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
    private static final KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
    private final ColumnSpec[] matchColumns = new ColumnSpec[]{new ColumnSpec("Source", 2, -1, Match.LabelComparator), new ColumnSpec("Matches", 4, 60, Match.MatchesComparator), new ColumnSpec("Lines", 4, 45, Match.LinesComparator)};
    private JTextField rootDirectoryField = new JTextField(System.getProperty("user.home"));
    private JTextField minimumLengthField = new JTextField(Integer.toString(75));
    private JTextField timeField = new JTextField(6);
    private JLabel phaseLabel = new JLabel();
    private JProgressBar tokenizingFilesBar = new JProgressBar();
    private JTextArea resultsTextArea = new JTextArea();
    private JCheckBox recurseCheckbox = new JCheckBox("", true);
    private JCheckBox ignoreLiteralsCheckbox = new JCheckBox("", false);
    private JComboBox languageBox = new JComboBox();
    private JTextField extensionField = new JTextField();
    private JLabel extensionLabel = new JLabel("Extension:", 4);
    private JTable resultsTable = new JTable();
    private JButton goButton;
    private JButton cancelButton;
    private JPanel progressPanel;
    private JFrame frame;
    private boolean trimLeadingWhitespace;
    private List matches = new ArrayList();

    private static LanguageConfig languageConfigFor(String label) {
        return (LanguageConfig)langConfigsByLabel.get(label);
    }

    private void addSaveOptionsTo(JMenu menu) {
        for (int i = 0; i < rendererSets.length; ++i) {
            JMenuItem saveItem = new JMenuItem("Save as " + rendererSets[i][0]);
            saveItem.addActionListener(new SaveListener((Renderer)rendererSets[i][1]));
            menu.add(saveItem);
        }
    }

    public GUI() {
        this.frame = new JFrame("PMD Duplicate Code Detector");
        this.timeField.setEditable(false);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        this.addSaveOptionsTo(fileMenu);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setMnemonic('x');
        exitItem.addActionListener(new CancelListener());
        fileMenu.add(exitItem);
        JMenu viewMenu = new JMenu("View");
        fileMenu.setMnemonic('v');
        JCheckBoxMenuItem trimItem = new JCheckBoxMenuItem("Trim leading whitespace");
        trimItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AbstractButton button = (AbstractButton)e.getItem();
                GUI.this.trimLeadingWhitespace = button.isSelected();
            }
        });
        viewMenu.add(trimItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        this.frame.setJMenuBar(menuBar);
        JButton browseButton = new JButton("Browse");
        browseButton.setMnemonic('b');
        browseButton.addActionListener(new BrowseListener());
        this.goButton = new JButton("Go");
        this.goButton.setMnemonic('g');
        this.goButton.addActionListener(new GoListener());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new CancelListener());
        JPanel settingsPanel = this.makeSettingsPanel(browseButton, this.goButton, this.cancelButton);
        this.progressPanel = this.makeProgressPanel();
        JPanel resultsPanel = this.makeResultsPanel();
        this.adjustLanguageControlsFor((LanguageConfig)languageSets[0][1]);
        this.frame.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)settingsPanel, "North");
        topPanel.add((Component)this.progressPanel, "Center");
        this.setProgressControls(false);
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)resultsPanel, "Center");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void adjustLanguageControlsFor(LanguageConfig current) {
        this.ignoreLiteralsCheckbox.setEnabled(current.ignoreLiteralsByDefault());
        this.extensionField.setText(current.extensions()[0]);
        boolean enableExtension = current.extensions()[0].length() == 0;
        this.extensionField.setEnabled(enableExtension);
        this.extensionLabel.setEnabled(enableExtension);
    }

    private JPanel makeSettingsPanel(JButton browseButton, JButton goButton, JButton cxButton) {
        JPanel settingsPanel = new JPanel();
        GridBagHelper helper = new GridBagHelper(settingsPanel, new double[]{0.2, 0.7, 0.1, 0.1});
        helper.addLabel("Root source directory:");
        helper.add(this.rootDirectoryField);
        helper.add(browseButton, 2);
        helper.nextRow();
        helper.addLabel("Report duplicate chunks larger than:");
        this.minimumLengthField.setColumns(4);
        helper.add(this.minimumLengthField);
        helper.addLabel("Language:");
        for (int i = 0; i < languageSets.length; ++i) {
            this.languageBox.addItem(languageSets[i][0]);
        }
        this.languageBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.adjustLanguageControlsFor(GUI.languageConfigFor((String)GUI.this.languageBox.getSelectedItem()));
            }
        });
        helper.add(this.languageBox);
        helper.nextRow();
        helper.addLabel("Also scan subdirectories?");
        helper.add(this.recurseCheckbox);
        helper.add(this.extensionLabel);
        helper.add(this.extensionField);
        helper.nextRow();
        helper.addLabel("Ignore literals and identifiers?");
        helper.add(this.ignoreLiteralsCheckbox);
        helper.add(goButton);
        helper.add(cxButton);
        helper.nextRow();
        return settingsPanel;
    }

    private JPanel makeProgressPanel() {
        JPanel progressPanel = new JPanel();
        double[] weights = new double[]{0.0, 0.8, 0.4, 0.2};
        GridBagHelper helper = new GridBagHelper(progressPanel, weights);
        helper.addLabel("Tokenizing files:");
        helper.add(this.tokenizingFilesBar, 3);
        helper.nextRow();
        helper.addLabel("Phase:");
        helper.add(this.phaseLabel);
        helper.addLabel("Time elapsed:");
        helper.add(this.timeField);
        helper.nextRow();
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        return progressPanel;
    }

    private JPanel makeResultsPanel() {
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BorderLayout());
        JScrollPane areaScrollPane = new JScrollPane(this.resultsTextArea);
        this.resultsTextArea.setEditable(false);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(600, 300));
        resultsPanel.add((Component)this.makeMatchList(), "West");
        resultsPanel.add((Component)areaScrollPane, "Center");
        return resultsPanel;
    }

    private void populateResultArea() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        TableModel model = this.resultsTable.getModel();
        ArrayList<Object> selections = new ArrayList<Object>(selectionIndices.length);
        for (int i = 0; i < selectionIndices.length; ++i) {
            selections.add(model.getValueAt(selectionIndices[i], 99));
        }
        String report = new SimpleRenderer(this.trimLeadingWhitespace).render(selections.iterator());
        this.resultsTextArea.setText(report);
        this.resultsTextArea.setCaretPosition(0);
    }

    private void copyMatchListSelectionsToClipboard() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        int colCount = this.resultsTable.getColumnCount();
        StringBuffer sb = new StringBuffer();
        for (int r = 0; r < selectionIndices.length; ++r) {
            if (r > 0) {
                sb.append('\n');
            }
            sb.append(this.resultsTable.getValueAt(selectionIndices[r], 0));
            for (int c = 1; c < colCount; ++c) {
                sb.append('\t');
                sb.append(this.resultsTable.getValueAt(selectionIndices[r], c));
            }
        }
        StringSelection ss = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    private void deleteMatchlistSelections() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        for (int i = selectionIndices.length - 1; i >= 0; --i) {
            this.matches.remove(selectionIndices[i]);
        }
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.addNotify();
    }

    private JComponent makeMatchList() {
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GUI.this.populateResultArea();
            }
        });
        this.resultsTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.copyMatchListSelectionsToClipboard();
            }
        }, "Copy", copy, 0);
        this.resultsTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.deleteMatchlistSelections();
            }
        }, "Del", delete, 0);
        int[] alignments = new int[this.matchColumns.length];
        for (int i = 0; i < alignments.length; ++i) {
            alignments[i] = this.matchColumns[i].alignment();
        }
        this.resultsTable.setDefaultRenderer(Object.class, new AlignmentRenderer(alignments));
        final JTableHeader header = this.resultsTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GUI.this.sortOnColumn(header.columnAtPoint(new Point(e.getX(), e.getY())));
            }
        });
        return new JScrollPane(this.resultsTable);
    }

    private boolean isLegalPath(String path, LanguageConfig config) {
        String[] extensions = config.extensions();
        for (int i = 0; i < extensions.length; ++i) {
            if (!path.endsWith(extensions[i]) || extensions[i].length() <= 0) continue;
            return true;
        }
        return false;
    }

    private String setLabelFor(Match match) {
        String label;
        HashSet<String> sourceIDs = new HashSet<String>(match.getMarkCount());
        Iterator occurrences = match.iterator();
        while (occurrences.hasNext()) {
            sourceIDs.add(((TokenEntry)occurrences.next()).getTokenSrcID());
        }
        if (sourceIDs.size() == 1) {
            String sourceId = (String)sourceIDs.iterator().next();
            int separatorPos = sourceId.lastIndexOf(File.separatorChar);
            label = "..." + sourceId.substring(separatorPos);
        } else {
            label = "(" + sourceIDs.size() + " separate files)";
        }
        match.setLabel(label);
        return label;
    }

    private void setProgressControls(boolean isRunning) {
        this.progressPanel.setVisible(isRunning);
        this.goButton.setEnabled(!isRunning);
        this.cancelButton.setEnabled(isRunning);
    }

    private void go() {
        String dirPath = this.rootDirectoryField.getText();
        try {
            if (!new File(dirPath).exists()) {
                JOptionPane.showMessageDialog(this.frame, "Can't read from that root source directory", "Error", 0);
                return;
            }
            this.setProgressControls(true);
            Properties p = new Properties();
            p.setProperty("ignore_literals", String.valueOf(this.ignoreLiteralsCheckbox.isSelected()));
            p.setProperty("extension", this.extensionField.getText());
            LanguageConfig conf = GUI.languageConfigFor((String)this.languageBox.getSelectedItem());
            Language language = conf.languageFor(new LanguageFactory(), p);
            CPD cpd = new CPD(Integer.parseInt(this.minimumLengthField.getText()), language);
            cpd.setCpdListener(this);
            this.tokenizingFilesBar.setMinimum(0);
            this.phaseLabel.setText("");
            if (this.isLegalPath(dirPath, conf)) {
                cpd.add(new File(dirPath));
            } else if (this.recurseCheckbox.isSelected()) {
                cpd.addRecursively(dirPath);
            } else {
                cpd.addAllInDirectory(dirPath);
            }
            final long start = System.currentTimeMillis();
            Timer t = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    long now = System.currentTimeMillis();
                    long elapsedMillis = now - start;
                    long elapsedSeconds = elapsedMillis / 1000L;
                    long minutes = (long)Math.floor(elapsedSeconds / 60L);
                    long seconds = elapsedSeconds - minutes * 60L;
                    GUI.this.timeField.setText("" + this.munge(String.valueOf(minutes)) + ':' + this.munge(String.valueOf(seconds)));
                }

                private String munge(String in) {
                    if (in.length() < 2) {
                        in = "0" + in;
                    }
                    return in;
                }
            });
            t.start();
            cpd.go();
            t.stop();
            this.matches = new ArrayList();
            Iterator i = cpd.getMatches();
            while (i.hasNext()) {
                Match match = (Match)i.next();
                this.setLabelFor(match);
                this.matches.add(match);
            }
            String report = new SimpleRenderer().render(cpd.getMatches());
            if (report.length() == 0) {
                JOptionPane.showMessageDialog(this.frame, "Done; couldn't find any duplicates longer than " + this.minimumLengthField.getText() + " tokens");
            } else {
                this.resultsTextArea.setText(report);
                this.setListDataFrom(cpd.getMatches());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Halted due to " + t.getClass().getName() + "; " + t.getMessage());
        }
        this.setProgressControls(false);
    }

    private TableModel tableModelFrom(final List items) {
        SortingTableModel model = new SortingTableModel(){
            private int sortColumn;
            private boolean sortDescending;

            public Object getValueAt(int rowIndex, int columnIndex) {
                Match match = (Match)items.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return match.getLabel();
                    }
                    case 2: {
                        return Integer.toString(match.getLineCount());
                    }
                    case 1: {
                        return match.getMarkCount() > 2 ? Integer.toString(match.getMarkCount()) : "";
                    }
                    case 99: {
                        return match;
                    }
                }
                return "";
            }

            public int getColumnCount() {
                return GUI.this.matchColumns.length;
            }

            public int getRowCount() {
                return items.size();
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int columnIndex) {
                return class$java$lang$Object == null ? (class$java$lang$Object = GUI.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            public String getColumnName(int i) {
                return GUI.this.matchColumns[i].label();
            }

            public void addTableModelListener(TableModelListener l) {
            }

            public void removeTableModelListener(TableModelListener l) {
            }

            public int sortColumn() {
                return this.sortColumn;
            }

            public void sortColumn(int column) {
                this.sortColumn = column;
            }

            public boolean sortDescending() {
                return this.sortDescending;
            }

            public void sortDescending(boolean flag) {
                this.sortDescending = flag;
            }

            public void sort(Comparator comparator) {
                Collections.sort(items, comparator);
                if (this.sortDescending) {
                    Collections.reverse(items);
                }
            }
        };
        return model;
    }

    private void sortOnColumn(int columnIndex) {
        Comparator comparator = this.matchColumns[columnIndex].sorter();
        SortingTableModel model = (SortingTableModel)this.resultsTable.getModel();
        if (model.sortColumn() == columnIndex) {
            model.sortDescending(!model.sortDescending());
        }
        model.sortColumn(columnIndex);
        model.sort(comparator);
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.repaint();
    }

    private void setListDataFrom(Iterator iter) {
        this.resultsTable.setModel(this.tableModelFrom(this.matches));
        TableColumnModel colModel = this.resultsTable.getColumnModel();
        for (int i = 0; i < this.matchColumns.length; ++i) {
            if (this.matchColumns[i].width() <= 0) continue;
            TableColumn column = colModel.getColumn(i);
            int width = this.matchColumns[i].width();
            column.setPreferredWidth(width);
            column.setMinWidth(width);
            column.setMaxWidth(width);
        }
    }

    public void phaseUpdate(int phase) {
        this.phaseLabel.setText(this.getPhaseText(phase));
    }

    public String getPhaseText(int phase) {
        switch (phase) {
            case 0: {
                return "Initializing";
            }
            case 1: {
                return "Hashing";
            }
            case 2: {
                return "Matching";
            }
            case 3: {
                return "Grouping";
            }
            case 4: {
                return "Done";
            }
        }
        return "Unknown";
    }

    public void addedFile(int fileCount, File file) {
        this.tokenizingFilesBar.setMaximum(fileCount);
        this.tokenizingFilesBar.setValue(this.tokenizingFilesBar.getValue() + 1);
    }

    public static void main(String[] args) {
        new GUI();
    }

    static /* synthetic */ JProgressBar access$100(GUI x0) {
        return x0.tokenizingFilesBar;
    }

    static /* synthetic */ JTextArea access$200(GUI x0) {
        return x0.resultsTextArea;
    }

    static /* synthetic */ JLabel access$300(GUI x0) {
        return x0.phaseLabel;
    }

    static /* synthetic */ void access$500(GUI x0) {
        x0.go();
    }

    static {
        for (int i = 0; i < languageSets.length; ++i) {
            langConfigsByLabel.put(languageSets[i][0], languageSets[i][1]);
        }
    }

    private static interface SortingTableModel
    extends TableModel {
        public int sortColumn();

        public void sortColumn(int var1);

        public boolean sortDescending();

        public void sortDescending(boolean var1);

        public void sort(Comparator var1);
    }

    private class AlignmentRenderer
    extends DefaultTableCellRenderer {
        private int[] alignments;

        public AlignmentRenderer(int[] theAlignments) {
            this.alignments = theAlignments;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(this.alignments[column]);
            return this;
        }
    }

    private class BrowseListener
    implements ActionListener {
        private BrowseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(GUI.this.rootDirectoryField.getText());
            fc.setFileSelectionMode(2);
            fc.showDialog(GUI.this.frame, "Select");
            if (fc.getSelectedFile() != null) {
                GUI.this.rootDirectoryField.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        final Renderer renderer;

        public SaveListener(Renderer theRenderer) {
            this.renderer = theRenderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fcSave = new JFileChooser();
            int ret = fcSave.showSaveDialog(GUI.this.frame);
            File f = fcSave.getSelectedFile();
            if (f == null || ret != 0) {
                return;
            }
            if (!f.canWrite()) {
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(new FileOutputStream(f));
                    pw.write(this.renderer.render(GUI.this.matches.iterator()));
                    pw.flush();
                    JOptionPane.showMessageDialog(GUI.this.frame, "Saved " + GUI.this.matches.size() + " matches");
                }
                catch (IOException e) {
                    this.error("Couldn't save file" + f.getAbsolutePath(), e);
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                }
            } else {
                this.error("Could not write to file " + f.getAbsolutePath(), null);
            }
        }

        private void error(String message, Exception e) {
            if (e != null) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(GUI.this.frame, message);
        }
    }

    private class GoListener
    implements ActionListener {
        private GoListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(this){
                private final /* synthetic */ GoListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    GUI.access$100(GoListener.access$000(this.this$1)).setValue(0);
                    GUI.access$100(GoListener.access$000(this.this$1)).setString("");
                    GUI.access$200(GoListener.access$000(this.this$1)).setText("");
                    GUI.access$300(GoListener.access$000(this.this$1)).setText("");
                    GUI.access$400(GoListener.access$000(this.this$1)).setText("");
                    GUI.access$500(GoListener.access$000(this.this$1));
                }
            }).start();
        }

        static /* synthetic */ GUI access$000(GoListener x0) {
            return x0.GUI.this;
        }
    }

    private static class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    private class ColumnSpec {
        private String label;
        private int alignment;
        private int width;
        private Comparator sorter;

        public ColumnSpec(String aLabel, int anAlignment, int aWidth, Comparator aSorter) {
            this.label = aLabel;
            this.alignment = anAlignment;
            this.width = aWidth;
            this.sorter = aSorter;
        }

        public String label() {
            return this.label;
        }

        public int alignment() {
            return this.alignment;
        }

        public int width() {
            return this.width;
        }

        public Comparator sorter() {
            return this.sorter;
        }
    }

    private static interface LanguageConfig {
        public Language languageFor(LanguageFactory var1, Properties var2);

        public boolean ignoreLiteralsByDefault();

        public String[] extensions();
    }

    private static interface Renderer {
        public String render(Iterator var1);
    }
}

