/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class UnnecessaryLocalBeforeReturn
extends AbstractRule {
    public Object visit(ASTMethodDeclaration meth, Object data) {
        if (meth.isVoid() || meth.isAbstract() || meth.isNative()) {
            return data;
        }
        return super.visit(meth, data);
    }

    public Object visit(ASTReturnStatement rtn, Object data) {
        ASTName name = (ASTName)rtn.getFirstChildOfType(ASTName.class);
        if (name == null) {
            return data;
        }
        if (rtn.findChildrenOfType(ASTExpression.class).size() > 1 || rtn.findChildrenOfType(ASTPrimaryExpression.class).size() > 1 || this.isMethodCall(rtn)) {
            return data;
        }
        Map vars = name.getScope().getVariableDeclarations();
        Iterator i = vars.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            VariableNameDeclaration key = (VariableNameDeclaration)entry.getKey();
            List usages = (List)entry.getValue();
            Iterator j = usages.iterator();
            while (j.hasNext()) {
                NameOccurrence occ = (NameOccurrence)j.next();
                if (!occ.getLocation().equals(name) || key.getNode().getBeginLine() != name.getBeginLine() - 1) continue;
                String var = name.getImage();
                if (var.indexOf(46) != -1) {
                    var = var.substring(0, var.indexOf(46));
                }
                this.addViolation(data, rtn, var);
            }
        }
        return data;
    }

    private boolean isMethodCall(ASTReturnStatement rtn) {
        List suffix = rtn.findChildrenOfType(ASTPrimarySuffix.class);
        Iterator iter = suffix.iterator();
        while (iter.hasNext()) {
            ASTPrimarySuffix element = (ASTPrimarySuffix)iter.next();
            if (!element.isArguments()) continue;
            return true;
        }
        return false;
    }
}

