/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.AbstractScope;
import net.sourceforge.pmd.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.symboltable.VariableUsageFinderFunction;
import net.sourceforge.pmd.util.Applier;

public class MethodScope
extends AbstractScope {
    protected Map variableNames = new HashMap();
    private SimpleNode node;

    public MethodScope(SimpleNode node) {
        this.node = node;
    }

    public MethodScope getEnclosingMethodScope() {
        return this;
    }

    public Map getVariableDeclarations() {
        VariableUsageFinderFunction f = new VariableUsageFinderFunction(this.variableNames);
        Applier.apply(f, this.variableNames.keySet().iterator());
        return f.getUsed();
    }

    public NameDeclaration addVariableNameOccurrence(NameOccurrence occurrence) {
        NameDeclaration decl = this.findVariableHere(occurrence);
        if (decl != null && !occurrence.isThisOrSuper()) {
            ((List)this.variableNames.get(decl)).add(occurrence);
            SimpleNode n = occurrence.getLocation();
            if (n instanceof ASTName) {
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return decl;
    }

    public void addDeclaration(VariableNameDeclaration variableDecl) {
        if (this.variableNames.containsKey(variableDecl)) {
            throw new RuntimeException("Variable " + variableDecl + " is already in the symbol table");
        }
        this.variableNames.put(variableDecl, new ArrayList());
    }

    public NameDeclaration findVariableHere(NameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.isMethodOrConstructorInvocation()) {
            return null;
        }
        ImageFinderFunction finder = new ImageFinderFunction(occurrence.getImage());
        Applier.apply(finder, this.variableNames.keySet().iterator());
        return finder.getDecl();
    }

    public String getName() {
        if (this.node instanceof ASTConstructorDeclaration) {
            return this.getEnclosingClassScope().getClassName();
        }
        return ((SimpleNode)this.node.jjtGetChild(1)).getImage();
    }

    public String toString() {
        return "MethodScope:" + this.glomNames(this.variableNames.keySet().iterator());
    }
}

