/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "vai" locale.
 */
public class LocalizedNamesImpl_vai extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "EU",
        "EZ",
        "HK",
        "MO",
        "QO",
        "UN",
        "XA",
        "XB",
        "ER",
        "BZ",
        "SL",
        "TL",
        "LY",
        "LB",
        "RE",
        "SC",
        "CL",
        "IO",
        "VG",
        "JP",
        "YE",
        "KY",
        "CV",
        "CX",
        "KE",
        "ET",
        "IN",
        "IT",
        "IQ",
        "IR",
        "ID",
        "PN",
        "PR",
        "PH",
        "FJ",
        "TF",
        "FI",
        "TA",
        "DG",
        "LS",
        "LT",
        "LI",
        "SN",
        "SJ",
        "SY",
        "SG",
        "SI",
        "SK",
        "PM",
        "VC",
        "SX",
        "KN",
        "LC",
        "SH",
        "NZ",
        "ZW",
        "DJ",
        "GI",
        "CP",
        "KI",
        "KG",
        "CU",
        "GN",
        "GW",
        "EG",
        "MM",
        "FM",
        "NP",
        "NI",
        "IE",
        "IS",
        "ZA",
        "CF",
        "AF",
        "DZ",
        "AL",
        "AI",
        "AM",
        "AX",
        "AZ",
        "AD",
        "AO",
        "AW",
        "AR",
        "AG",
        "AQ",
        "HT",
        "WF",
        "PS",
        "PK",
        "PY",
        "PA",
        "PW",
        "PG",
        "ES",
        "BB",
        "BD",
        "IL",
        "BS",
        "BH",
        "FK",
        "FO",
        "VA",
        "VE",
        "VU",
        "TW",
        "TH",
        "TJ",
        "TV",
        "TZ",
        "DK",
        "LR",
        "LV",
        "SA",
        "LA",
        "RW",
        "EH",
        "ST",
        "WS",
        "CY",
        "ZM",
        "CN",
        "TD",
        "GL",
        "DE",
        "JM",
        "CM",
        "BQ",
        "NC",
        "QA",
        "KZ",
        "CA",
        "KH",
        "BL",
        "MF",
        "GM",
        "GH",
        "GA",
        "MY",
        "MK",
        "MQ",
        "ML",
        "MV",
        "SM",
        "MT",
        "MH",
        "MG",
        "MW",
        "YT",
        "IM",
        "NG",
        "NE",
        "NA",
        "OM",
        "US",
        "AS",
        "UM",
        "VI",
        "PT",
        "PL",
        "BO",
        "BA",
        "BF",
        "BW",
        "MZ",
        "TK",
        "TG",
        "DM",
        "DO",
        "RO",
        "NR",
        "SO",
        "HR",
        "CI",
        "KR",
        "KP",
        "CR",
        "CK",
        "KM",
        "XK",
        "CC",
        "CG",
        "CD",
        "MD",
        "GB",
        "BV",
        "BT",
        "BR",
        "BI",
        "BN",
        "FR",
        "TT",
        "TN",
        "GQ",
        "CH",
        "SE",
        "LK",
        "SR",
        "SZ",
        "SS",
        "SB",
        "SD",
        "UY",
        "UG",
        "AE",
        "UA",
        "UZ",
        "KW",
        "CW",
        "GT",
        "GP",
        "GU",
        "GD",
        "GY",
        "GG",
        "NU",
        "AT",
        "AU",
        "HN",
        "HU",
        "BG",
        "TO",
        "TR",
        "TC",
        "TM",
        "LU",
        "RU",
        "GE",
        "GS",
        "JO",
        "MP",
        "IC",
        "CO",
        "MR",
        "MU",
        "ME",
        "MA",
        "MC",
        "MN",
        "MS",
        "NO",
        "NF",
        "EE",
        "EC",
        "SV",
        "HM",
        "GR",
        "PE",
        "BE",
        "BJ",
        "BY",
        "BM",
        "PF",
        "GF",
        "VN",
        "EA",
        "RS",
        "AC",
        "CZ",
        "JE",
        "MX",
        "NL",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AC", "ꗻꗡ ꕒꕡꕌ ꗏ ꔳꘋꗣ");
    namesMap.put("AD", "ꕉꖆꕟ");
    namesMap.put("AE", "ꖳꕯꔤꗳ ꕉꕟꔬ ꗡꕆꔓꔻ");
    namesMap.put("AF", "ꕉꔱꕭꔕꔻꕚꘋ");
    namesMap.put("AG", "ꕉꘋꔳꖶꕎ ꗪ ꕑꖜꕜ");
    namesMap.put("AI", "ꕉꕄꕞ");
    namesMap.put("AL", "ꕉꔷꕑꕇꕩ");
    namesMap.put("AM", "ꕉꕆꕯ");
    namesMap.put("AO", "ꕉꖐꕞ");
    namesMap.put("AQ", "ꕉꘋꕚꔳꕪ");
    namesMap.put("AR", "ꕉꘀꘋꔳꕯ");
    namesMap.put("AS", "ꕶꕱ ꕢꕹꕎ");
    namesMap.put("AT", "ꖺꔻꖤꕎ");
    namesMap.put("AU", "ꖺꖬꖤꔃꔷꕩ");
    namesMap.put("AW", "ꕉꖩꕑ");
    namesMap.put("AX", "ꕉꕞꔺ");
    namesMap.put("AZ", "ꕉꕤꕑꔤꕧꘋ");
    namesMap.put("BA", "ꕷꔻꕇꕰ ꗪ ꗥꕤꖑꔲꕯ");
    namesMap.put("BB", "ꕑꔆꖁꔻ");
    namesMap.put("BD", "ꕑꕅꕞꗵꔼ");
    namesMap.put("BE", "ꗩꕀꗚꘋ");
    namesMap.put("BF", "ꕷꕃꕯ ꕘꖇ");
    namesMap.put("BG", "ꗂꔠꔸꕩ");
    namesMap.put("BH", "ꕑꗸꘋ");
    namesMap.put("BI", "ꖜꖩꔺ");
    namesMap.put("BJ", "ꗩꕇꘋ");
    namesMap.put("BL", "ꕪꘋꕓ ꗞꗢ ꕒꕚꕞꕆ");
    namesMap.put("BM", "ꗩꖷꕜ");
    namesMap.put("BN", "ꖜꖩꘉꔧ");
    namesMap.put("BO", "ꕷꔷꔲꕩ");
    namesMap.put("BQ", "ꕪꔓꔬꘂꘋ ꖨꕮ ꗨꗳꗣ");
    namesMap.put("BR", "ꖜꕟꔘꔀ");
    namesMap.put("BS", "ꕑꕌꕮꔻ");
    namesMap.put("BT", "ꖜꕚꘋ");
    namesMap.put("BV", "ꖜꔍꔳ ꔳꘋꗣ");
    namesMap.put("BW", "ꕷꖬꕎꕯ");
    namesMap.put("BY", "ꗩꕞꖩꔻ");
    namesMap.put("BZ", "ꔆꔷꔘ");
    namesMap.put("CA", "ꕪꕯꕜ");
    namesMap.put("CC", "ꖏꖏꔻ (ꔞꔀꔷꘋ) ꔳꘋꗣ");
    namesMap.put("CD", "ꖏꖐ ꗵꗞꖴꕟꔎ ꕸꖃꔀ");
    namesMap.put("CF", "ꕉꔱꔸꕪ ꗳ ꗳ ꕸꖃꔀ");
    namesMap.put("CG", "ꖏꖐ");
    namesMap.put("CH", "ꖬꔃꕤ ꖨꕮꕊ");
    namesMap.put("CI", "ꖏꔳ ꕾꕎ");
    namesMap.put("CK", "ꖏꕃ ꔳꘋꗣ");
    namesMap.put("CL", "ꔚꔷ");
    namesMap.put("CM", "ꕪꔈꖩꘋ");
    namesMap.put("CN", "ꕦꔤꕯ");
    namesMap.put("CO", "ꗛꗏꔭꕩ");
    namesMap.put("CP", "ꕃꔒꕐꗋꘋ ꔳꘋꗣ");
    namesMap.put("CR", "ꖏꔻꕚ ꔸꕪ");
    namesMap.put("CU", "ꕃꖳꕑ");
    namesMap.put("CV", "ꔞꔪ ꗲꔵ ꔳꘋꗣ");
    namesMap.put("CW", "ꖴꕟꖇꕱ");
    namesMap.put("CX", "ꔞꔻꕮꔻ ꔳꘋꗣ");
    namesMap.put("CY", "ꕢꗡꖛꗐꔻ");
    namesMap.put("CZ", "ꗿꕃ ꕸꖃꔀ");
    namesMap.put("DE", "ꕧꕮꔧ");
    namesMap.put("DG", "ꔵꔀꖑ ꔳꘋꗣ");
    namesMap.put("DJ", "ꕀꖜꔳ");
    namesMap.put("DK", "ꕜꕇꕮꕃ");
    namesMap.put("DM", "ꖁꕆꕇꕪ");
    namesMap.put("DO", "ꖁꕆꕇꕪꘋ ꕸꕱꔀ");
    namesMap.put("DZ", "ꕉꔷꔠꔸꕩ");
    namesMap.put("EA", "ꗻꕚ ꗪ ꔡꔷꕞ");
    namesMap.put("EC", "ꗡꖴꔃꗍ");
    namesMap.put("EE", "ꗡꔻꕿꕇꕰ");
    namesMap.put("EG", "ꕆꔖꕞ");
    namesMap.put("EH", "ꕢꕌꕟ ꔎꔒ ꕀꔤ");
    namesMap.put("ER", "ꔀꔸꔳꕟ");
    namesMap.put("ES", "ꕐꘊꔧ");
    namesMap.put("ET", "ꔤꔳꖎꔪꕩ");
    namesMap.put("FI", "ꔱꘋ ꖨꕮꕊ");
    namesMap.put("FJ", "ꔱꔤꕀ");
    namesMap.put("FK", "ꕘꔷꕃ ꖨꕮ ꔳꘋꗣ");
    namesMap.put("FM", "ꕆꖏꕇꔻꕩ");
    namesMap.put("FO", "ꕘꖄ ꔳꘋꗣ");
    namesMap.put("FR", "ꖢꕟꘋꔻ");
    namesMap.put("GA", "ꕭꕷꘋ");
    namesMap.put("GB", "ꖕꕯꔤꗳ");
    namesMap.put("GD", "ꖶꕟꕯꕜ");
    namesMap.put("GE", "ꗘꖺꕀꕩ");
    namesMap.put("GF", "ꗱꘋꔻ ꖶꕎꕯ");
    namesMap.put("GG", "ꖶꗦꘋꔻ");
    namesMap.put("GH", "ꕭꕌꕯ");
    namesMap.put("GI", "ꕀꖜꕟꕚ");
    namesMap.put("GL", "ꕧꕓ ꖴꕎ ꖨꕮꕊ");
    namesMap.put("GM", "ꕭꔭꕩ");
    namesMap.put("GN", "ꕅꔤꕇ");
    namesMap.put("GP", "ꖶꕎꔐꖨꔅ");
    namesMap.put("GQ", "ꖦꕰꕊ ꗳ ꕅꔤꕇ");
    namesMap.put("GR", "ꗥꗷꘋ");
    namesMap.put("GS", "ꗘꖺꕀꕩ ꗛꔤ ꔒꘋꗣ ꗏ ꗪ ꗇꖢ ꔳꘋꗣ ꗛꔤ ꔒꘋꗣ ꗏ");
    namesMap.put("GT", "ꖶꕎꔎꕮꕞ");
    namesMap.put("GU", "ꖶꕎꕆ");
    namesMap.put("GW", "ꕅꔤꕇ ꔫꕢꕴ");
    namesMap.put("GY", "ꖶꕩꕯ");
    namesMap.put("HM", "ꗥꗡꔵ ꗪ ꕮꖁꕯ");
    namesMap.put("HN", "ꖽꖫꕟ");
    namesMap.put("HR", "ꖏꔓꔻꕩ");
    namesMap.put("HT", "ꕌꔤꔳ");
    namesMap.put("HU", "ꖽꘋꕭꔓ");
    namesMap.put("IC", "ꗛꖺꔻꕩ ꔳꘋꗣ");
    namesMap.put("ID", "ꔤꖆꕇꔻꕩ");
    namesMap.put("IE", "ꕉꔓ ꖨꕮꕊ");
    namesMap.put("IL", "ꕑꕇꔻꕞꔤꕞ");
    namesMap.put("IM", "ꕮꘋ ꔳꘋꗣ");
    namesMap.put("IN", "ꔤꔺꕩ");
    namesMap.put("IO", "ꔛꔟꔻ ꔤꔺꕩ ꗛꔤꘂ ꕗꕴꔀ ꕮ");
    namesMap.put("IQ", "ꔤꕟꕃ");
    namesMap.put("IR", "ꔤꕟꘋ");
    namesMap.put("IS", "ꕉꔤꔻ ꖨꕮꕊ");
    namesMap.put("IT", "ꔤꕚꔷ");
    namesMap.put("JE", "ꘀꗡꔘ");
    namesMap.put("JM", "ꕧꕮꔧꕪ");
    namesMap.put("JO", "ꗘꖺꗵꘋ");
    namesMap.put("JP", "ꔛꗨꗢ");
    namesMap.put("KE", "ꔞꕰ");
    namesMap.put("KG", "ꕃꕅꔻꕚꘋ");
    namesMap.put("KH", "ꕪꕹꔵꕩ");
    namesMap.put("KI", "ꕃꔸꕑꔳ");
    namesMap.put("KM", "ꖏꕹꖄꔻ");
    namesMap.put("KN", "ꔻꘋ ꕃꔳꔻ ꗪ ꔕꔲꔻ");
    namesMap.put("KP", "ꖏꔸꕩ ꗛꔤ ꕪꘋꗒ");
    namesMap.put("KR", "ꖏꔸꕩ ꗛꔤ ꔒꘋꗣ ꗏ");
    namesMap.put("KW", "ꖴꔃꔳ");
    namesMap.put("KY", "ꔞꔀꕮꘋ ꔳꘋꗣ");
    namesMap.put("KZ", "ꕪꕤꔻꕚꘋ");
    namesMap.put("LA", "ꕞꕴꔻ");
    namesMap.put("LB", "ꔒꕑꗟꘋ");
    namesMap.put("LC", "ꔻꘋ ꖨꔻꕩ");
    namesMap.put("LI", "ꔷꗿꘋꔻꗳꘋ");
    namesMap.put("LK", "ꖬꔸ ꕞꘋꕪ");
    namesMap.put("LR", "ꕞꔤꔫꕩ");
    namesMap.put("LS", "ꔷꖇꕿ");
    namesMap.put("LT", "ꔷꖤꔃꕇꕰ");
    namesMap.put("LU", "ꗏꔻꘋꗂꖺ");
    namesMap.put("LV", "ꕞꔳꔲꕩ");
    namesMap.put("LY", "ꔒꔫꕩ");
    namesMap.put("MA", "ꗞꕟꖏ");
    namesMap.put("MC", "ꗞꕯꖏ");
    namesMap.put("MD", "ꖒꔷꖁꕙ");
    namesMap.put("ME", "ꗞꔳꕇꖶꖄ");
    namesMap.put("MF", "ꕪꘋꕓ ꗞꗢ ꕮꕊꔳꘋ");
    namesMap.put("MG", "ꕮꕜꕭꔻꕪ");
    namesMap.put("MH", "ꕮꕊꕣ ꔳꘋꗣ");
    namesMap.put("MK", "ꕮꔖꖁꕇꕰ");
    namesMap.put("ML", "ꕮꔷ");
    namesMap.put("MM", "ꕆꕩꘋꕮ");
    namesMap.put("MN", "ꗞꖐꔷꕩ");
    namesMap.put("MP", "ꗛꔤ ꕪꘋꗒ ꕮꔸꕩꕯ ꔳꘋꗣ");
    namesMap.put("MQ", "ꕮꔳꕇꕃ");
    namesMap.put("MR", "ꗞꔓꔎꕇꕰ");
    namesMap.put("MS", "ꗞꘋꔖꕟꔳ");
    namesMap.put("MT", "ꕮꕊꕚ");
    namesMap.put("MU", "ꗞꔓꗔ");
    namesMap.put("MV", "ꕮꔷꕜꔍ");
    namesMap.put("MW", "ꕮꕞꕌꔨ");
    namesMap.put("MX", "ꘈꔻꖏ");
    namesMap.put("MY", "ꕮꔒꔻꕩ");
    namesMap.put("MZ", "ꕹꕤꔭꕃ");
    namesMap.put("NA", "ꕯꕆꔫꕩ");
    namesMap.put("NC", "ꕪꔷꖁꕇꕰ ꕯꕮꕊ");
    namesMap.put("NE", "ꕯꔤꕧ");
    namesMap.put("NF", "ꗟꖺꗉ ꔳꘋꗣ");
    namesMap.put("NG", "ꕯꔤꕀꔸꕩ");
    namesMap.put("NI", "ꕇꕪꕟꖶꕎ");
    namesMap.put("NL", "ꘉꕜ ꖨꕮꕊ");
    namesMap.put("NO", "ꗟꖺꔃ");
    namesMap.put("NP", "ꕇꕐꔷ");
    namesMap.put("NR", "ꖆꖩ");
    namesMap.put("NU", "ꖸꔃꔤ");
    namesMap.put("NZ", "ꔽꔤ ꖨꕮ ꕯꕮꕊ");
    namesMap.put("OM", "ꕱꕮꘋ");
    namesMap.put("PA", "ꕐꕯꕮ");
    namesMap.put("PE", "ꗨꗡꖩ");
    namesMap.put("PF", "ꗱꘋꔻ ꕶꔷꕇꔻꕩ");
    namesMap.put("PG", "ꕐꖛꕎ ꕅꔤꕇ ꕯꕮꕊ");
    namesMap.put("PH", "ꔱꔒꔪꘋ");
    namesMap.put("PK", "ꕐꕃꔻꕚꘋ");
    namesMap.put("PL", "ꕶꗷꘋ");
    namesMap.put("PM", "ꔻꘋ ꔪꘂ ꗪ ꕆꔞꗏꘋ");
    namesMap.put("PN", "ꔪꔳꕪꕆ");
    namesMap.put("PR", "ꔪꖳꕿ ꔸꖏ");
    namesMap.put("PS", "ꕐꔒꔻꔳꕯ ꔎꔒ ꕀꔤ ꗛꔤ ꕞ ꗱ ꗪ ꕭꕌꕤ");
    namesMap.put("PT", "ꕶꕿꕃꔤ ꕸꖃꔀ");
    namesMap.put("PW", "ꕐꖃ");
    namesMap.put("PY", "ꕐꕟꗝꔀ");
    namesMap.put("QA", "ꕪꕚꕌ");
    namesMap.put("RE", "ꔓꗠꖻ");
    namesMap.put("RO", "ꖄꕆꕇꕰ");
    namesMap.put("RS", "ꗻꗡꔬꕩ");
    namesMap.put("RU", "ꗐꖺꔻꕩ");
    namesMap.put("RW", "ꕟꖙꕡ");
    namesMap.put("SA", "ꕞꕌꖝ ꕸꖃꔀ");
    namesMap.put("SB", "ꖬꕞꔤꕮꕊꕯ ꔳꘋꗣ");
    namesMap.put("SC", "ꔖꗼꔷ");
    namesMap.put("SD", "ꖬꗵꘋ");
    namesMap.put("SE", "ꖬꔨꗵꘋ");
    namesMap.put("SG", "ꔻꕬꕶꕱ");
    namesMap.put("SH", "ꔻꘋ ꗥꔷꕯ");
    namesMap.put("SI", "ꔻꖃꔍꕇꕰ");
    namesMap.put("SJ", "ꔻꕙꕒꔵ ꗪ ꕧꘋ ꕮꘂꘋ");
    namesMap.put("SK", "ꔻꖃꕙꕃꕩ");
    namesMap.put("SL", "ꔋꕩ ꕒꕌꖺ ꕸꖃꔀ");
    namesMap.put("SM", "ꕮꔸꖆ ꕢꘋ");
    namesMap.put("SN", "ꔻꕇꕭꕌ");
    namesMap.put("SO", "ꖇꕮꔷꕩ");
    namesMap.put("SR", "ꖬꔸꕯꔈ");
    namesMap.put("SS", "ꖬꕜꘋ ꗛꔤ ꔒꘋꗣ ꗏ");
    namesMap.put("ST", "ꕢꕴ ꕿꔈ ꗪ ꕉ ꕮꔧ ꕗꕴꔀ");
    namesMap.put("SV", "ꗡꗷ ꕢꔍꗍꖺ");
    namesMap.put("SX", "ꔻꘋꔳ ꕮꕊꗳꘋ");
    namesMap.put("SY", "ꔻꕩꘋ");
    namesMap.put("SZ", "ꖬꕎꔽ ꖨꕮꕊ");
    namesMap.put("TA", "ꔳꔻꕚꘋ ꕜ ꖴꕯ");
    namesMap.put("TC", "ꗋꖺꕃꔻ ꗪ ꕪꔤꖏꔻ ꔳꘋꗣ");
    namesMap.put("TD", "ꕦꔵ");
    namesMap.put("TF", "ꔱꗷꘋꔻ ꗛꔤ ꔒꘋꗣ ꗏ ꕸꖃꔀ ꖸ");
    namesMap.put("TG", "ꕿꖑ");
    namesMap.put("TH", "ꕚꔤ ꖨꕮꕊ");
    namesMap.put("TJ", "ꕚꕀꕃꔻꕚꘋ");
    namesMap.put("TK", "ꕿꔞꖃ");
    namesMap.put("TL", "ꔎꔒ ꗃ ꔳꗞꖻ");
    namesMap.put("TM", "ꗋꖺꕃꕮꕇꔻꕚꘋ");
    namesMap.put("TN", "ꖤꕇꔻꕩ");
    namesMap.put("TO", "ꗋꕬ");
    namesMap.put("TR", "ꗋꖺꕃ");
    namesMap.put("TT", "ꖤꔸꔕꕜ ꗪ ꕿꔆꖑ");
    namesMap.put("TV", "ꕚꖣꖨ");
    namesMap.put("TW", "ꕚꔤꕎꘋ");
    namesMap.put("TZ", "ꕚꘋꕤꕇꕰ");
    namesMap.put("UA", "ꖳꖴꔓꘋ");
    namesMap.put("UG", "ꖳꕭꕡ");
    namesMap.put("UM", "ꕶꕱ ꕪꘋ ꗅꘋ ꔳꘋꗣ ꖸ");
    namesMap.put("US", "ꕶꕱ");
    namesMap.put("UY", "ꖳꔓꗝꔀ");
    namesMap.put("UZ", "ꖳꗩꕃꔻꕚꘋ");
    namesMap.put("VA", "ꕙꔳꕪꘋ ꕢꕨꕌ");
    namesMap.put("VC", "ꔻꘋ ꔲꘋꔻꘋ ꗪ ꖶꔓꕯꔵꘋ ꖸ");
    namesMap.put("VE", "ꕙꔳꕪꘋ ꕸꖃꔀ");
    namesMap.put("VG", "ꔛꔟꔻ ꗩꗡ ꗏ ꖷꖬ ꔳꘋꗣ");
    namesMap.put("VI", "ꕶꕱ ꗩꗡ ꗏ ꖷꖬ ꔳꘋꗣ");
    namesMap.put("VN", "ꗲꕇꖮꔃꕞ");
    namesMap.put("VU", "ꕙꖸꕎꖤ");
    namesMap.put("WF", "ꕎꔷꔻ ꗪ ꖢꖤꕯ");
    namesMap.put("WS", "ꕢꕹꖙꕉ");
    namesMap.put("XK", "ꖏꖇꕾ");
    namesMap.put("YE", "ꔝꘈꘋ");
    namesMap.put("YT", "ꕮꗚꔎ");
    namesMap.put("ZA", "ꕉꔱꔸꕪ ꗛꔤ ꔒꘋꗣ ꗏ ꕸꖃꔀ");
    namesMap.put("ZM", "ꕤꔭꕩ");
    namesMap.put("ZW", "ꔽꕓꖜꔃ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AC": "ꗻꗡ ꕒꕡꕌ ꗏ ꔳꘋꗣ",
        "AD": "ꕉꖆꕟ",
        "AE": "ꖳꕯꔤꗳ ꕉꕟꔬ ꗡꕆꔓꔻ",
        "AF": "ꕉꔱꕭꔕꔻꕚꘋ",
        "AG": "ꕉꘋꔳꖶꕎ ꗪ ꕑꖜꕜ",
        "AI": "ꕉꕄꕞ",
        "AL": "ꕉꔷꕑꕇꕩ",
        "AM": "ꕉꕆꕯ",
        "AO": "ꕉꖐꕞ",
        "AQ": "ꕉꘋꕚꔳꕪ",
        "AR": "ꕉꘀꘋꔳꕯ",
        "AS": "ꕶꕱ ꕢꕹꕎ",
        "AT": "ꖺꔻꖤꕎ",
        "AU": "ꖺꖬꖤꔃꔷꕩ",
        "AW": "ꕉꖩꕑ",
        "AX": "ꕉꕞꔺ",
        "AZ": "ꕉꕤꕑꔤꕧꘋ",
        "BA": "ꕷꔻꕇꕰ ꗪ ꗥꕤꖑꔲꕯ",
        "BB": "ꕑꔆꖁꔻ",
        "BD": "ꕑꕅꕞꗵꔼ",
        "BE": "ꗩꕀꗚꘋ",
        "BF": "ꕷꕃꕯ ꕘꖇ",
        "BG": "ꗂꔠꔸꕩ",
        "BH": "ꕑꗸꘋ",
        "BI": "ꖜꖩꔺ",
        "BJ": "ꗩꕇꘋ",
        "BL": "ꕪꘋꕓ ꗞꗢ ꕒꕚꕞꕆ",
        "BM": "ꗩꖷꕜ",
        "BN": "ꖜꖩꘉꔧ",
        "BO": "ꕷꔷꔲꕩ",
        "BQ": "ꕪꔓꔬꘂꘋ ꖨꕮ ꗨꗳꗣ",
        "BR": "ꖜꕟꔘꔀ",
        "BS": "ꕑꕌꕮꔻ",
        "BT": "ꖜꕚꘋ",
        "BV": "ꖜꔍꔳ ꔳꘋꗣ",
        "BW": "ꕷꖬꕎꕯ",
        "BY": "ꗩꕞꖩꔻ",
        "BZ": "ꔆꔷꔘ",
        "CA": "ꕪꕯꕜ",
        "CC": "ꖏꖏꔻ (ꔞꔀꔷꘋ) ꔳꘋꗣ",
        "CD": "ꖏꖐ ꗵꗞꖴꕟꔎ ꕸꖃꔀ",
        "CF": "ꕉꔱꔸꕪ ꗳ ꗳ ꕸꖃꔀ",
        "CG": "ꖏꖐ",
        "CH": "ꖬꔃꕤ ꖨꕮꕊ",
        "CI": "ꖏꔳ ꕾꕎ",
        "CK": "ꖏꕃ ꔳꘋꗣ",
        "CL": "ꔚꔷ",
        "CM": "ꕪꔈꖩꘋ",
        "CN": "ꕦꔤꕯ",
        "CO": "ꗛꗏꔭꕩ",
        "CP": "ꕃꔒꕐꗋꘋ ꔳꘋꗣ",
        "CR": "ꖏꔻꕚ ꔸꕪ",
        "CU": "ꕃꖳꕑ",
        "CV": "ꔞꔪ ꗲꔵ ꔳꘋꗣ",
        "CW": "ꖴꕟꖇꕱ",
        "CX": "ꔞꔻꕮꔻ ꔳꘋꗣ",
        "CY": "ꕢꗡꖛꗐꔻ",
        "CZ": "ꗿꕃ ꕸꖃꔀ",
        "DE": "ꕧꕮꔧ",
        "DG": "ꔵꔀꖑ ꔳꘋꗣ",
        "DJ": "ꕀꖜꔳ",
        "DK": "ꕜꕇꕮꕃ",
        "DM": "ꖁꕆꕇꕪ",
        "DO": "ꖁꕆꕇꕪꘋ ꕸꕱꔀ",
        "DZ": "ꕉꔷꔠꔸꕩ",
        "EA": "ꗻꕚ ꗪ ꔡꔷꕞ",
        "EC": "ꗡꖴꔃꗍ",
        "EE": "ꗡꔻꕿꕇꕰ",
        "EG": "ꕆꔖꕞ",
        "EH": "ꕢꕌꕟ ꔎꔒ ꕀꔤ",
        "ER": "ꔀꔸꔳꕟ",
        "ES": "ꕐꘊꔧ",
        "ET": "ꔤꔳꖎꔪꕩ",
        "FI": "ꔱꘋ ꖨꕮꕊ",
        "FJ": "ꔱꔤꕀ",
        "FK": "ꕘꔷꕃ ꖨꕮ ꔳꘋꗣ",
        "FM": "ꕆꖏꕇꔻꕩ",
        "FO": "ꕘꖄ ꔳꘋꗣ",
        "FR": "ꖢꕟꘋꔻ",
        "GA": "ꕭꕷꘋ",
        "GB": "ꖕꕯꔤꗳ",
        "GD": "ꖶꕟꕯꕜ",
        "GE": "ꗘꖺꕀꕩ",
        "GF": "ꗱꘋꔻ ꖶꕎꕯ",
        "GG": "ꖶꗦꘋꔻ",
        "GH": "ꕭꕌꕯ",
        "GI": "ꕀꖜꕟꕚ",
        "GL": "ꕧꕓ ꖴꕎ ꖨꕮꕊ",
        "GM": "ꕭꔭꕩ",
        "GN": "ꕅꔤꕇ",
        "GP": "ꖶꕎꔐꖨꔅ",
        "GQ": "ꖦꕰꕊ ꗳ ꕅꔤꕇ",
        "GR": "ꗥꗷꘋ",
        "GS": "ꗘꖺꕀꕩ ꗛꔤ ꔒꘋꗣ ꗏ ꗪ ꗇꖢ ꔳꘋꗣ ꗛꔤ ꔒꘋꗣ ꗏ",
        "GT": "ꖶꕎꔎꕮꕞ",
        "GU": "ꖶꕎꕆ",
        "GW": "ꕅꔤꕇ ꔫꕢꕴ",
        "GY": "ꖶꕩꕯ",
        "HM": "ꗥꗡꔵ ꗪ ꕮꖁꕯ",
        "HN": "ꖽꖫꕟ",
        "HR": "ꖏꔓꔻꕩ",
        "HT": "ꕌꔤꔳ",
        "HU": "ꖽꘋꕭꔓ",
        "IC": "ꗛꖺꔻꕩ ꔳꘋꗣ",
        "ID": "ꔤꖆꕇꔻꕩ",
        "IE": "ꕉꔓ ꖨꕮꕊ",
        "IL": "ꕑꕇꔻꕞꔤꕞ",
        "IM": "ꕮꘋ ꔳꘋꗣ",
        "IN": "ꔤꔺꕩ",
        "IO": "ꔛꔟꔻ ꔤꔺꕩ ꗛꔤꘂ ꕗꕴꔀ ꕮ",
        "IQ": "ꔤꕟꕃ",
        "IR": "ꔤꕟꘋ",
        "IS": "ꕉꔤꔻ ꖨꕮꕊ",
        "IT": "ꔤꕚꔷ",
        "JE": "ꘀꗡꔘ",
        "JM": "ꕧꕮꔧꕪ",
        "JO": "ꗘꖺꗵꘋ",
        "JP": "ꔛꗨꗢ",
        "KE": "ꔞꕰ",
        "KG": "ꕃꕅꔻꕚꘋ",
        "KH": "ꕪꕹꔵꕩ",
        "KI": "ꕃꔸꕑꔳ",
        "KM": "ꖏꕹꖄꔻ",
        "KN": "ꔻꘋ ꕃꔳꔻ ꗪ ꔕꔲꔻ",
        "KP": "ꖏꔸꕩ ꗛꔤ ꕪꘋꗒ",
        "KR": "ꖏꔸꕩ ꗛꔤ ꔒꘋꗣ ꗏ",
        "KW": "ꖴꔃꔳ",
        "KY": "ꔞꔀꕮꘋ ꔳꘋꗣ",
        "KZ": "ꕪꕤꔻꕚꘋ",
        "LA": "ꕞꕴꔻ",
        "LB": "ꔒꕑꗟꘋ",
        "LC": "ꔻꘋ ꖨꔻꕩ",
        "LI": "ꔷꗿꘋꔻꗳꘋ",
        "LK": "ꖬꔸ ꕞꘋꕪ",
        "LR": "ꕞꔤꔫꕩ",
        "LS": "ꔷꖇꕿ",
        "LT": "ꔷꖤꔃꕇꕰ",
        "LU": "ꗏꔻꘋꗂꖺ",
        "LV": "ꕞꔳꔲꕩ",
        "LY": "ꔒꔫꕩ",
        "MA": "ꗞꕟꖏ",
        "MC": "ꗞꕯꖏ",
        "MD": "ꖒꔷꖁꕙ",
        "ME": "ꗞꔳꕇꖶꖄ",
        "MF": "ꕪꘋꕓ ꗞꗢ ꕮꕊꔳꘋ",
        "MG": "ꕮꕜꕭꔻꕪ",
        "MH": "ꕮꕊꕣ ꔳꘋꗣ",
        "MK": "ꕮꔖꖁꕇꕰ",
        "ML": "ꕮꔷ",
        "MM": "ꕆꕩꘋꕮ",
        "MN": "ꗞꖐꔷꕩ",
        "MP": "ꗛꔤ ꕪꘋꗒ ꕮꔸꕩꕯ ꔳꘋꗣ",
        "MQ": "ꕮꔳꕇꕃ",
        "MR": "ꗞꔓꔎꕇꕰ",
        "MS": "ꗞꘋꔖꕟꔳ",
        "MT": "ꕮꕊꕚ",
        "MU": "ꗞꔓꗔ",
        "MV": "ꕮꔷꕜꔍ",
        "MW": "ꕮꕞꕌꔨ",
        "MX": "ꘈꔻꖏ",
        "MY": "ꕮꔒꔻꕩ",
        "MZ": "ꕹꕤꔭꕃ",
        "NA": "ꕯꕆꔫꕩ",
        "NC": "ꕪꔷꖁꕇꕰ ꕯꕮꕊ",
        "NE": "ꕯꔤꕧ",
        "NF": "ꗟꖺꗉ ꔳꘋꗣ",
        "NG": "ꕯꔤꕀꔸꕩ",
        "NI": "ꕇꕪꕟꖶꕎ",
        "NL": "ꘉꕜ ꖨꕮꕊ",
        "NO": "ꗟꖺꔃ",
        "NP": "ꕇꕐꔷ",
        "NR": "ꖆꖩ",
        "NU": "ꖸꔃꔤ",
        "NZ": "ꔽꔤ ꖨꕮ ꕯꕮꕊ",
        "OM": "ꕱꕮꘋ",
        "PA": "ꕐꕯꕮ",
        "PE": "ꗨꗡꖩ",
        "PF": "ꗱꘋꔻ ꕶꔷꕇꔻꕩ",
        "PG": "ꕐꖛꕎ ꕅꔤꕇ ꕯꕮꕊ",
        "PH": "ꔱꔒꔪꘋ",
        "PK": "ꕐꕃꔻꕚꘋ",
        "PL": "ꕶꗷꘋ",
        "PM": "ꔻꘋ ꔪꘂ ꗪ ꕆꔞꗏꘋ",
        "PN": "ꔪꔳꕪꕆ",
        "PR": "ꔪꖳꕿ ꔸꖏ",
        "PS": "ꕐꔒꔻꔳꕯ ꔎꔒ ꕀꔤ ꗛꔤ ꕞ ꗱ ꗪ ꕭꕌꕤ",
        "PT": "ꕶꕿꕃꔤ ꕸꖃꔀ",
        "PW": "ꕐꖃ",
        "PY": "ꕐꕟꗝꔀ",
        "QA": "ꕪꕚꕌ",
        "RE": "ꔓꗠꖻ",
        "RO": "ꖄꕆꕇꕰ",
        "RS": "ꗻꗡꔬꕩ",
        "RU": "ꗐꖺꔻꕩ",
        "RW": "ꕟꖙꕡ",
        "SA": "ꕞꕌꖝ ꕸꖃꔀ",
        "SB": "ꖬꕞꔤꕮꕊꕯ ꔳꘋꗣ",
        "SC": "ꔖꗼꔷ",
        "SD": "ꖬꗵꘋ",
        "SE": "ꖬꔨꗵꘋ",
        "SG": "ꔻꕬꕶꕱ",
        "SH": "ꔻꘋ ꗥꔷꕯ",
        "SI": "ꔻꖃꔍꕇꕰ",
        "SJ": "ꔻꕙꕒꔵ ꗪ ꕧꘋ ꕮꘂꘋ",
        "SK": "ꔻꖃꕙꕃꕩ",
        "SL": "ꔋꕩ ꕒꕌꖺ ꕸꖃꔀ",
        "SM": "ꕮꔸꖆ ꕢꘋ",
        "SN": "ꔻꕇꕭꕌ",
        "SO": "ꖇꕮꔷꕩ",
        "SR": "ꖬꔸꕯꔈ",
        "SS": "ꖬꕜꘋ ꗛꔤ ꔒꘋꗣ ꗏ",
        "ST": "ꕢꕴ ꕿꔈ ꗪ ꕉ ꕮꔧ ꕗꕴꔀ",
        "SV": "ꗡꗷ ꕢꔍꗍꖺ",
        "SX": "ꔻꘋꔳ ꕮꕊꗳꘋ",
        "SY": "ꔻꕩꘋ",
        "SZ": "ꖬꕎꔽ ꖨꕮꕊ",
        "TA": "ꔳꔻꕚꘋ ꕜ ꖴꕯ",
        "TC": "ꗋꖺꕃꔻ ꗪ ꕪꔤꖏꔻ ꔳꘋꗣ",
        "TD": "ꕦꔵ",
        "TF": "ꔱꗷꘋꔻ ꗛꔤ ꔒꘋꗣ ꗏ ꕸꖃꔀ ꖸ",
        "TG": "ꕿꖑ",
        "TH": "ꕚꔤ ꖨꕮꕊ",
        "TJ": "ꕚꕀꕃꔻꕚꘋ",
        "TK": "ꕿꔞꖃ",
        "TL": "ꔎꔒ ꗃ ꔳꗞꖻ",
        "TM": "ꗋꖺꕃꕮꕇꔻꕚꘋ",
        "TN": "ꖤꕇꔻꕩ",
        "TO": "ꗋꕬ",
        "TR": "ꗋꖺꕃ",
        "TT": "ꖤꔸꔕꕜ ꗪ ꕿꔆꖑ",
        "TV": "ꕚꖣꖨ",
        "TW": "ꕚꔤꕎꘋ",
        "TZ": "ꕚꘋꕤꕇꕰ",
        "UA": "ꖳꖴꔓꘋ",
        "UG": "ꖳꕭꕡ",
        "UM": "ꕶꕱ ꕪꘋ ꗅꘋ ꔳꘋꗣ ꖸ",
        "US": "ꕶꕱ",
        "UY": "ꖳꔓꗝꔀ",
        "UZ": "ꖳꗩꕃꔻꕚꘋ",
        "VA": "ꕙꔳꕪꘋ ꕢꕨꕌ",
        "VC": "ꔻꘋ ꔲꘋꔻꘋ ꗪ ꖶꔓꕯꔵꘋ ꖸ",
        "VE": "ꕙꔳꕪꘋ ꕸꖃꔀ",
        "VG": "ꔛꔟꔻ ꗩꗡ ꗏ ꖷꖬ ꔳꘋꗣ",
        "VI": "ꕶꕱ ꗩꗡ ꗏ ꖷꖬ ꔳꘋꗣ",
        "VN": "ꗲꕇꖮꔃꕞ",
        "VU": "ꕙꖸꕎꖤ",
        "WF": "ꕎꔷꔻ ꗪ ꖢꖤꕯ",
        "WS": "ꕢꕹꖙꕉ",
        "XK": "ꖏꖇꕾ",
        "YE": "ꔝꘈꘋ",
        "YT": "ꕮꗚꔎ",
        "ZA": "ꕉꔱꔸꕪ ꗛꔤ ꔒꘋꗣ ꗏ ꕸꖃꔀ",
        "ZM": "ꕤꔭꕩ",
        "ZW": "ꔽꕓꖜꔃ"
    };
  }-*/;
}
