/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.sampling.EbppsItemsSample;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EbppsItemsSampleTest {
    private static final double EPS = 1.0E-14;

    @Test
    public void basicInitialization() {
        EbppsItemsSample sample = new EbppsItemsSample(0);
        Assert.assertEquals((double)sample.getC(), (double)0.0);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)0);
        Assert.assertNull((Object)sample.getSample());
    }

    @Test
    public void initializeWithData() {
        double theta1 = 1.0;
        EbppsItemsSample sample = new EbppsItemsSample(1);
        sample.replaceContent((Object)-1, 1.0);
        Assert.assertEquals((double)sample.getC(), (double)1.0);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)1);
        Assert.assertEquals((int)sample.getSample().size(), (int)1);
        Assert.assertEquals((Integer)((Integer)sample.getSample().get(0)), (int)-1);
        Assert.assertFalse((boolean)sample.hasPartialItem());
        double theta2 = 1.0E-300;
        sample.replaceContent((Object)-2, 1.0E-300);
        Assert.assertEquals((double)sample.getC(), (double)1.0E-300);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)1);
        Assert.assertNull((Object)sample.getSample());
        Assert.assertTrue((boolean)sample.hasPartialItem());
    }

    @Test
    public void downsampleToZeroOrOneItem() {
        EbppsItemsSample sample = new EbppsItemsSample(1);
        sample.replaceContent((Object)"a", 1.0);
        sample.downsample(2.0);
        Assert.assertEquals((double)sample.getC(), (double)1.0);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)1);
        Assert.assertEquals((String)((String)sample.getSample().get(0)), (String)"a");
        Assert.assertFalse((boolean)sample.hasPartialItem());
        ArrayList<String> items = new ArrayList<String>(Arrays.asList("a", "b"));
        sample = new EbppsItemsSample(items, null, 1.8);
        sample.replaceRandom(new Random(85942L));
        sample.downsample(0.5);
        Assert.assertEquals((double)sample.getC(), (double)0.9);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)0);
        Assert.assertNull((Object)sample.getSample());
        Assert.assertFalse((boolean)sample.hasPartialItem());
        items = new ArrayList<String>(Arrays.asList("a", "b"));
        sample = new EbppsItemsSample(items, null, 1.5);
        sample.replaceRandom(new Random(15L));
        sample.downsample(0.5);
        Assert.assertEquals((double)sample.getC(), (double)0.75);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)1);
        Assert.assertTrue((boolean)sample.hasPartialItem());
        for (String s : sample.getSample()) {
            Assert.assertTrue(("a".equals(s) || "b".equals(s) ? 1 : 0) != 0);
        }
    }

    @Test
    public void downsampleMultipleItems() {
        ArrayList<String> items = new ArrayList<String>(Arrays.asList("a", "b", "c", "d", "e", "f", "g"));
        String partial = "h";
        ArrayList<String> referenceItems = new ArrayList<String>(items);
        referenceItems.add("h");
        EbppsItemsSample sample = new EbppsItemsSample(items, (Object)partial, 7.5);
        sample.downsample(0.8);
        Assert.assertEquals((double)sample.getC(), (double)6.0);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)6);
        Assert.assertFalse((boolean)sample.hasPartialItem());
        for (String s : sample.getSample()) {
            Assert.assertTrue((boolean)referenceItems.contains(s));
        }
        items = new ArrayList<String>(referenceItems);
        partial = "i";
        referenceItems.add("i");
        sample = new EbppsItemsSample(items, (Object)partial, 8.5);
        sample.downsample(0.8);
        Assert.assertEquals((double)sample.getC(), (double)6.8, (double)1.0E-14);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)7);
        Assert.assertTrue((boolean)sample.hasPartialItem());
        for (String s : sample.getSample()) {
            Assert.assertTrue((boolean)referenceItems.contains(s));
        }
    }

    @Test
    public void mergeUnitSamples() {
        int k = 8;
        EbppsItemsSample sample = new EbppsItemsSample(k);
        EbppsItemsSample s = new EbppsItemsSample(1);
        for (int i = 1; i <= k; ++i) {
            s.replaceContent((Object)i, 1.0);
            sample.merge(s);
            Assert.assertEquals((double)sample.getC(), (double)i);
            Assert.assertEquals((int)sample.getNumRetainedItems(), (int)i);
        }
        sample.reset();
        Assert.assertEquals((double)sample.getC(), (double)0.0);
        Assert.assertEquals((int)sample.getNumRetainedItems(), (int)0);
        Assert.assertFalse((boolean)sample.hasPartialItem());
    }
}

