/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.thetacommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.thetacommon.BoundsOnRatiosInThetaSketchedSets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BoundsOnRatiosInThetaSketchedSetsTest {
    @Test
    public void checkNormalReturns() {
        int i;
        UpdatableThetaSketch skA = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch skC = UpdatableThetaSketch.builder().build();
        int uA = 10000;
        int uC = 100000;
        for (i = 0; i < 10000; ++i) {
            skA.update((long)i);
        }
        for (i = 0; i < 100000; ++i) {
            skC.update((long)(i + 5000));
        }
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)skA);
        inter.intersect((ThetaSketch)skC);
        CompactThetaSketch skB = inter.getResult();
        double est = BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA((ThetaSketch)skA, (ThetaSketch)skB);
        double lb = BoundsOnRatiosInThetaSketchedSets.getLowerBoundForBoverA((ThetaSketch)skA, (ThetaSketch)skB);
        double ub = BoundsOnRatiosInThetaSketchedSets.getUpperBoundForBoverA((ThetaSketch)skA, (ThetaSketch)skB);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((est > lb ? 1 : 0) != 0);
        Assert.assertEquals((double)est, (double)0.5, (double)0.03);
        BoundsOnRatiosInThetaSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInThetaSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInThetaSketchedSetsTest.println("lb : " + lb);
        skA.reset();
        est = BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA((ThetaSketch)skA, (ThetaSketch)skB);
        lb = BoundsOnRatiosInThetaSketchedSets.getLowerBoundForBoverA((ThetaSketch)skA, (ThetaSketch)skB);
        ub = BoundsOnRatiosInThetaSketchedSets.getUpperBoundForBoverA((ThetaSketch)skA, (ThetaSketch)skB);
        BoundsOnRatiosInThetaSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInThetaSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInThetaSketchedSetsTest.println("lb : " + lb);
        skC.reset();
        est = BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA((ThetaSketch)skA, (ThetaSketch)skC);
        lb = BoundsOnRatiosInThetaSketchedSets.getLowerBoundForBoverA((ThetaSketch)skA, (ThetaSketch)skC);
        ub = BoundsOnRatiosInThetaSketchedSets.getUpperBoundForBoverA((ThetaSketch)skA, (ThetaSketch)skC);
        BoundsOnRatiosInThetaSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInThetaSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInThetaSketchedSetsTest.println("lb : " + lb);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAbnormalReturns() {
        int i;
        UpdatableThetaSketch skA = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch skC = UpdatableThetaSketch.builder().build();
        int uA = 100000;
        int uC = 10000;
        for (i = 0; i < 100000; ++i) {
            skA.update((long)i);
        }
        for (i = 0; i < 10000; ++i) {
            skC.update((long)(i + 50000));
        }
        BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA((ThetaSketch)skA, (ThetaSketch)skC);
    }

    @Test
    public void printlnTest() {
        BoundsOnRatiosInThetaSketchedSetsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

