/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesUnionTest {
    @Test
    public void heapExactMode() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union.union((ArrayOfDoublesSketch)sketch1);
        union.union((ArrayOfDoublesSketch)sketch2);
        int maxBytes = ArrayOfDoublesUnion.getMaxBytes((int)4096, (int)1);
        Assert.assertEquals((int)maxBytes, (int)131120);
        ArrayOfDoublesCompactSketch result = union.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)3.0);
        double[][] values = result.getValues();
        Assert.assertEquals((double)values[0][0], (double)3.0);
        Assert.assertEquals((double)values[1][0], (double)3.0);
        Assert.assertEquals((double)values[2][0], (double)3.0);
        MemorySegment wseg = MemorySegment.ofArray(union.toByteArray());
        ArrayOfDoublesUnion wrappedUnion = ArrayOfDoublesSketch.wrapUnion((MemorySegment)wseg);
        result = wrappedUnion.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)3.0);
        values = result.getValues();
        Assert.assertEquals((double)values[0][0], (double)3.0);
        Assert.assertEquals((double)values[1][0], (double)3.0);
        Assert.assertEquals((double)values[2][0], (double)3.0);
        union.reset();
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getTheta(), (double)1.0);
    }

    @Test
    public void heapEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union.union((ArrayOfDoublesSketch)sketch1);
        union.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        union.reset();
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getTheta(), (double)1.0);
    }

    @Test
    public void heapEstimationModeFullOverlapTwoValuesAndDownsizing() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0, 2.0});
        }
        key = 0;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0, 2.0});
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNumberOfValues(2).setNominalEntries(1024).buildUnion();
        union.union((ArrayOfDoublesSketch)sketch1);
        union.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)8192.0, (double)81.92);
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1024);
        ArrayOfDoublesSketchIterator it = result.iterator();
        double[] expected = new double[]{2.0, 4.0};
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])expected, (String)(Arrays.toString(it.getValues()) + " != " + Arrays.toString(expected)));
        }
    }

    @Test
    public void heapMixedMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 500;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setSamplingProbability(0.2f).build();
        for (int i = 0; i < 20000; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union.union((ArrayOfDoublesSketch)sketch1);
        union.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)20500.0, (double)205.0);
    }

    @Test
    public void heapSerializeDeserialize() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union1.union((ArrayOfDoublesSketch)sketch1);
        union1.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesUnion.heapify((MemorySegment)MemorySegment.ofArray(union1.toByteArray()));
        ArrayOfDoublesCompactSketch result = union2.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        union2.reset();
        result = union2.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getTheta(), (double)1.0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((double)values[i][0], (double)2.0);
        }
    }

    @Test
    public void heapSerializeDeserializeWithSeed() {
        long seed = 1L;
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().setSeed(1L).buildUnion();
        union1.union((ArrayOfDoublesSketch)sketch1);
        union1.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesUnion.heapify((MemorySegment)MemorySegment.ofArray(union1.toByteArray()), (long)1L);
        ArrayOfDoublesCompactSketch result = union2.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
    }

    @Test
    public void directSerializeDeserialize() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().buildUnion(MemorySegment.ofArray(new byte[1000000]));
        union1.union((ArrayOfDoublesSketch)sketch1);
        union1.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesUnion.wrap((MemorySegment)MemorySegment.ofArray(union1.toByteArray()));
        ArrayOfDoublesCompactSketch result = union2.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        union2.reset();
        result = union2.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getTheta(), (double)1.0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((double)values[i][0], (double)2.0);
        }
    }

    @Test
    public void directSerializeDeserializeWithSeed() {
        long seed = 1L;
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().setSeed(1L).buildUnion(MemorySegment.ofArray(new byte[1000000]));
        union1.union((ArrayOfDoublesSketch)sketch1);
        union1.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesUnion.wrap((MemorySegment)MemorySegment.ofArray(union1.toByteArray()), (long)1L);
        ArrayOfDoublesCompactSketch result = union2.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
    }

    @Test
    public void directExactMode() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion(MemorySegment.ofArray(new byte[1000000]));
        union.union((ArrayOfDoublesSketch)sketch1);
        union.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertEquals((double)result.getEstimate(), (double)3.0);
        double[][] values = result.getValues();
        Assert.assertEquals((double)values[0][0], (double)3.0);
        Assert.assertEquals((double)values[1][0], (double)3.0);
        Assert.assertEquals((double)values[2][0], (double)3.0);
        union.reset();
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getTheta(), (double)1.0);
    }

    @Test
    public void directEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion(MemorySegment.ofArray(new byte[1000000]));
        union.union((ArrayOfDoublesSketch)sketch1);
        union.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        union.reset();
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getTheta(), (double)1.0);
    }

    @Test
    public void heapToDirect() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesUnion heapUnion = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        heapUnion.union((ArrayOfDoublesSketch)sketch1);
        ArrayOfDoublesUnion directUnion = ArrayOfDoublesUnion.wrap((MemorySegment)MemorySegment.ofArray(heapUnion.toByteArray()));
        directUnion.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = directUnion.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)3.0);
        double[][] values = result.getValues();
        Assert.assertEquals((int)values.length, (int)3);
        Assert.assertEquals((double)values[0][0], (double)3.0);
        Assert.assertEquals((double)values[1][0], (double)3.0);
        Assert.assertEquals((double)values[2][0], (double)3.0);
    }

    @Test
    public void directToHeap() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesUnion directUnion = new ArrayOfDoublesSetOperationBuilder().buildUnion(MemorySegment.ofArray(new byte[1000000]));
        directUnion.union((ArrayOfDoublesSketch)sketch1);
        ArrayOfDoublesUnion heapUnion = ArrayOfDoublesUnion.heapify((MemorySegment)MemorySegment.ofArray(directUnion.toByteArray()));
        heapUnion.union((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = heapUnion.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)3.0);
        double[][] values = result.getValues();
        Assert.assertEquals((int)values.length, (int)3);
        Assert.assertEquals((double)values[0][0], (double)3.0);
        Assert.assertEquals((double)values[1][0], (double)3.0);
        Assert.assertEquals((double)values[2][0], (double)3.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleSeeds() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setSeed(2L).buildUnion();
        union.union((ArrayOfDoublesSketch)sketch);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleInputSketchFewerValues() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNumberOfValues(2).buildUnion();
        union.union((ArrayOfDoublesSketch)sketch);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleInputSketchMoreValues() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union.union((ArrayOfDoublesSketch)sketch);
    }

    @Test
    public void directDruidUsageOneSketch() {
        MemorySegment seg = MemorySegment.ofArray(new byte[1000000]);
        new ArrayOfDoublesSetOperationBuilder().buildUnion(seg);
        int n = 100000;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 100000; ++i) {
            sketch.update((long)i, new double[]{1.0});
        }
        sketch.trim();
        MemorySegment seg2 = MemorySegment.ofArray(new byte[1000000]);
        ArrayOfDoublesCompactSketch dcsk = sketch.compact(seg2);
        ArrayOfDoublesUnion union = ArrayOfDoublesSketch.wrapUnion((MemorySegment)seg);
        union.union((ArrayOfDoublesSketch)dcsk);
        ArrayOfDoublesCompactSketch result = ArrayOfDoublesUnion.wrap((MemorySegment)seg).getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)sketch.getEstimate());
        Assert.assertEquals((boolean)result.isEstimationMode(), (boolean)sketch.isEstimationMode());
    }

    @Test
    public void directDruidUsageTwoSketches() {
        MemorySegment seg = MemorySegment.ofArray(new byte[1000000]);
        new ArrayOfDoublesSetOperationBuilder().buildUnion(seg);
        int key = 0;
        int n1 = 100000;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 100000; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesSketch.wrapUnion((MemorySegment)seg).union((ArrayOfDoublesSketch)sketch1.compact(MemorySegment.ofArray(new byte[1000000])));
        int n2 = 1000000;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 1000000; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesSketch.wrapUnion((MemorySegment)seg).union((ArrayOfDoublesSketch)sketch2.compact(MemorySegment.ofArray(new byte[1000000])));
        key = 0;
        int n = 1100000;
        ArrayOfDoublesUpdatableSketch expected = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 1100000; ++i) {
            expected.update((long)key++, new double[]{1.0});
        }
        expected.trim();
        ArrayOfDoublesCompactSketch result = ArrayOfDoublesUnion.wrap((MemorySegment)seg).getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)expected.getEstimate());
        Assert.assertEquals((boolean)result.isEstimationMode(), (boolean)expected.isEstimationMode());
        Assert.assertEquals((double)result.getUpperBound(1), (double)expected.getUpperBound(1));
        Assert.assertEquals((double)result.getLowerBound(1), (double)expected.getLowerBound(1));
        Assert.assertEquals((int)result.getRetainedEntries(), (int)expected.getRetainedEntries());
        Assert.assertEquals((int)result.getNumValues(), (int)expected.getNumValues());
    }
}

