/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
package org.apache.jdo.tck.api.persistencemanagerfactory.config;

import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.StoreLifecycleListener;

/**
 * A StoreLifecycleListener implementation that provides a getInstance() method
 * that may be invoked by a JDO implementation.
 */
public class StoreListenerGetInstance implements StoreLifecycleListener {

    private static boolean preStore = false;
    private static boolean postStore = false;
    private static int instanceCount = 0;
    private static StoreListenerGetInstance slInstance = 
            new StoreListenerGetInstance();

    private StoreListenerGetInstance() {
        instanceCount++;
    }

    public static StoreListenerGetInstance getInstance() {
        return slInstance;
    }

    public static boolean isPreStore() {
        return preStore;
    }

    public static boolean isPostStore() {
        return postStore;
    }

    public static void resetValues() {
        preStore = false;
        postStore = false;
    }

    public void preStore(InstanceLifecycleEvent event) {
//        System.out.println("preStore: event is " + event);
        preStore = true;
    }

    public void postStore(InstanceLifecycleEvent event) {
//        System.out.println("postStore: event is " + event);
        postStore = true;
    }
}
