package org.apache.torque.manager;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.List;

import org.apache.torque.om.Persistent;

/**
 * Listener for cache events
 *
 * @param <T> The database object class for which this instance is a listener.
 * @author <a href="mailto:jmcnally@collab.net">John McNally</a>
 * @version $Id: CacheListener.java 1379317 2012-08-31 06:56:48Z tfischer $
 */
public interface CacheListener<T extends Persistent>
{
    /**
     *
     * @param om
     */
    void addedObject(T om);

    /**
     *
     * @param om
     */
    void refreshedObject(T om);

    //public void removedObject(T om);

    /**
     *
     */
    List<String> getInterestedFields();
}
