/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static Map<Class<?>, PropertyDescriptor[][]> beanInfos = Collections.synchronizedMap(new WeakHashMap());
    private static final PropertyDescriptor INVALID_PROPERTY = new PropertyDescriptor(null, null, null, null);

    public static boolean hasDefaultConstructor(Class type) {
        Constructor<?>[] constructors;
        if (!Modifier.isPublic(type.getModifiers())) {
            return false;
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return false;
        }
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getImplementedInterfaces(Set<String> classes, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            for (Class<?> itf : clazz.getInterfaces()) {
                if (Modifier.isPublic(itf.getModifiers())) {
                    classes.add(itf.getName());
                }
                ReflectionUtils.getImplementedInterfaces(classes, itf);
            }
            ReflectionUtils.getImplementedInterfaces(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Set<String> getSuperClasses(Set<String> classes, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                classes.add(clazz.getName());
            }
            ReflectionUtils.getSuperClasses(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Method getLifecycleMethod(Class clazz, String name) {
        if (name != null) {
            try {
                Method method = clazz.getMethod(name, new Class[0]);
                if (Void.TYPE.equals(method.getReturnType())) {
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Method> findCompatibleMethods(Class clazz, String name, Class[] paramTypes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            Class<?>[] methodParams = method.getParameterTypes();
            if (!name.equals(method.getName()) || !Void.TYPE.equals(method.getReturnType()) || methodParams.length != paramTypes.length || method.isBridge()) continue;
            boolean assignable = true;
            for (int i = 0; i < paramTypes.length && assignable; assignable &= paramTypes[i] == null || methodParams[i].isAssignableFrom(paramTypes[i]), ++i) {
            }
            if (!assignable) continue;
            methods.add(method);
        }
        return methods;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz, boolean allowFieldInjection) {
        int index;
        PropertyDescriptor[][] properties = beanInfos.get(clazz);
        int n = index = allowFieldInjection ? 0 : 1;
        if (properties == null) {
            properties = new PropertyDescriptor[2][];
            beanInfos.put(clazz, properties);
        }
        if (properties[index] == null) {
            String name;
            HashMap<String, PropertyDescriptor> props = new HashMap<String, PropertyDescriptor>();
            for (Method method : clazz.getMethods()) {
                Class<?> resultType;
                if (Modifier.isStatic(method.getModifiers()) || method.isBridge()) continue;
                name = method.getName();
                Class<?>[] argTypes = method.getParameterTypes();
                Class<?> argType = resultType = method.getReturnType();
                Method getter = null;
                Method setter = null;
                if (name.length() > 3 && name.startsWith("set") && resultType == Void.TYPE && argTypes.length == 1) {
                    name = ReflectionUtils.decapitalize(name.substring(3));
                    setter = method;
                    argType = argTypes[0];
                } else if (name.length() > 3 && name.startsWith("get") && argTypes.length == 0) {
                    name = ReflectionUtils.decapitalize(name.substring(3));
                    getter = method;
                } else {
                    if (name.length() <= 2 || !name.startsWith("is") || argTypes.length != 0 || resultType != Boolean.TYPE) continue;
                    name = ReflectionUtils.decapitalize(name.substring(2));
                    getter = method;
                }
                if (props.containsKey(name)) {
                    PropertyDescriptor pd = (PropertyDescriptor)props.get(name);
                    if (pd == INVALID_PROPERTY) continue;
                    if (!argType.equals(pd.type)) {
                        props.put(name, INVALID_PROPERTY);
                        continue;
                    }
                    if (getter != null) {
                        if (pd.getter == null || pd.getter.equals(getter)) {
                            pd.getter = getter;
                            continue;
                        }
                        props.put(name, INVALID_PROPERTY);
                        continue;
                    }
                    if (setter == null) continue;
                    if (pd.setter == null || pd.setter.equals(setter)) {
                        pd.setter = setter;
                        continue;
                    }
                    props.put(name, INVALID_PROPERTY);
                    continue;
                }
                props.put(name, new PropertyDescriptor(name, argType, getter, setter));
            }
            if (allowFieldInjection) {
                for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                    name = ReflectionUtils.decapitalize(((Field)accessibleObject).getName());
                    if (!props.containsKey(name)) {
                        props.put(name, new PropertyDescriptor(name, ((Field)accessibleObject).getType(), (Field)accessibleObject));
                        continue;
                    }
                    PropertyDescriptor pd = (PropertyDescriptor)props.get(name);
                    if (pd == INVALID_PROPERTY || !pd.type.equals(((Field)accessibleObject).getType())) continue;
                    pd.field = (Field)accessibleObject;
                }
            }
            Iterator it = props.values().iterator();
            while (it.hasNext()) {
                if (it.next() != INVALID_PROPERTY) continue;
                it.remove();
            }
            Collection tmp = props.values();
            properties[index] = tmp.toArray(new PropertyDescriptor[tmp.size()]);
        }
        return properties[index];
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static Object invoke(AccessControlContext acc, final Method method, final Object instance, final Object ... args) throws Exception {
        if (acc == null) {
            return method.invoke(instance, args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke(instance, args);
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Object newInstance(AccessControlContext acc, final Class clazz) throws Exception {
        if (acc == null) {
            return clazz.newInstance();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return clazz.newInstance();
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Object newInstance(AccessControlContext acc, final Constructor constructor, final Object ... args) throws Exception {
        if (acc == null) {
            return constructor.newInstance(args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return constructor.newInstance(args);
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Throwable getRealCause(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyDescriptor {
        private String name;
        private Class<?> type;
        private Method getter;
        private Method setter;
        private Field field;

        public PropertyDescriptor(String name, Class<?> type, Method getter, Method setter) {
            this.name = name;
            this.type = type;
            this.getter = getter;
            this.setter = setter;
        }

        public PropertyDescriptor(String name, Class<?> type, Field field) {
            this.name = name;
            this.type = type;
            this.field = field;
            this.getter = null;
            this.setter = null;
        }

        public String getName() {
            return this.name;
        }

        public boolean allowsGet() {
            return this.getter != null || this.field != null;
        }

        public boolean allowsSet() {
            return this.setter != null || this.field != null;
        }

        public Object get(final Object instance, AccessControlContext acc) throws Exception {
            if (acc == null) {
                return this.internalGet(instance);
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return PropertyDescriptor.this.internalGet(instance);
                    }
                }, acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }

        private Object internalGet(Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.getter != null) {
                return this.getter.invoke(instance, new Object[0]);
            }
            if (this.field != null) {
                this.field.setAccessible(true);
                return this.field.get(instance);
            }
            throw new UnsupportedOperationException();
        }

        public void set(final Object instance, final Object value, AccessControlContext acc) throws Exception {
            if (acc == null) {
                this.internalSet(instance, value);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            PropertyDescriptor.this.internalSet(instance, value);
                            return null;
                        }
                    }, acc);
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        }

        private void internalSet(Object instance, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.setter != null) {
                this.setter.invoke(instance, value);
            } else if (this.field != null) {
                this.field.setAccessible(true);
                this.field.set(instance, value);
            } else {
                throw new UnsupportedOperationException();
            }
        }

        public Type getGenericType() {
            if (this.setter != null) {
                return this.setter.getGenericParameterTypes()[0];
            }
            if (this.getter != null) {
                return this.getter.getGenericReturnType();
            }
            return this.field.getGenericType();
        }

        public String toString() {
            return "PropertyDescriptor <name: " + this.name + ", getter: " + this.getter + ", setter: " + this.setter + ", field: " + this.field + ">";
        }
    }
}

