/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.deployer.blueprint;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintTransformer {
    static Transformer transformer;
    static DocumentBuilderFactory dbf;
    static TransformerFactory tf;
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final Pattern ARTIFACT_MATCHER;
    private static final Pattern FUZZY_MODIFIDER;

    public static void transform(URL url, OutputStream os) throws Exception {
        Object e;
        Document doc = BlueprintTransformer.parse(url);
        String name = url.getPath();
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        String[] str = BlueprintTransformer.extractNameVersionType(name);
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "2");
        m.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        m.getMainAttributes().putValue("Bundle-SymbolicName", str[0]);
        m.getMainAttributes().putValue("Bundle-Version", str[1]);
        String importPkgs = BlueprintTransformer.getImportPackages(BlueprintTransformer.analyze(new DOMSource(doc)));
        if (importPkgs != null && importPkgs.length() > 0) {
            m.getMainAttributes().putValue("Import-Package", importPkgs);
        }
        m.getMainAttributes().putValue("DynamicImport-Package", "*");
        NodeList l = doc.getElementsByTagName("manifest");
        if (l != null) {
            for (int i = 0; i < l.getLength(); ++i) {
                e = (Element)l.item(i);
                String text = e.getTextContent();
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(text.trim().getBytes()));
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String k = (String)en.nextElement();
                    String v = props.getProperty(k);
                    m.getMainAttributes().putValue(k, v);
                }
                e.getParentNode().removeChild((Node)e);
            }
        }
        JarOutputStream out = new JarOutputStream(os);
        e = new ZipEntry("META-INF/MANIFEST.MF");
        out.putNextEntry((ZipEntry)e);
        m.write(out);
        out.closeEntry();
        e = new ZipEntry("OSGI-INF/");
        out.putNextEntry((ZipEntry)e);
        e = new ZipEntry("OSGI-INF/blueprint/");
        out.putNextEntry((ZipEntry)e);
        out.closeEntry();
        e = new ZipEntry("OSGI-INF/blueprint/" + name);
        out.putNextEntry((ZipEntry)e);
        if (tf == null) {
            tf = TransformerFactory.newInstance();
        }
        tf.newTransformer().transform(new DOMSource(doc), new StreamResult(out));
        out.closeEntry();
        out.close();
    }

    public static String[] extractNameVersionType(String url) {
        Matcher m = ARTIFACT_MATCHER.matcher(url);
        if (!m.matches()) {
            return new String[]{url, DEFAULT_VERSION};
        }
        StringBuffer v = new StringBuffer();
        String d1 = m.group(1);
        String d2 = m.group(2);
        String d3 = m.group(3);
        String d4 = m.group(4);
        String d5 = m.group(5);
        String d6 = m.group(6);
        if (d2 != null) {
            v.append(d2);
            if (d3 != null) {
                v.append('.');
                v.append(d3);
                if (d4 != null) {
                    v.append('.');
                    v.append(d4);
                    if (d5 != null) {
                        v.append(".");
                        BlueprintTransformer.cleanupModifier(v, d5);
                    }
                } else if (d5 != null) {
                    v.append(".0.");
                    BlueprintTransformer.cleanupModifier(v, d5);
                }
            } else if (d5 != null) {
                v.append(".0.0.");
                BlueprintTransformer.cleanupModifier(v, d5);
            }
        }
        return new String[]{d1, v.toString(), d6};
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = FUZZY_MODIFIDER.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(1);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }

    public static Set<String> analyze(Source source) throws Exception {
        if (transformer == null) {
            if (tf == null) {
                tf = TransformerFactory.newInstance();
            }
            StreamSource s = new StreamSource(BlueprintTransformer.class.getResourceAsStream("extract.xsl"));
            transformer = tf.newTransformer(s);
        }
        TreeSet<String> refers = new TreeSet<String>();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamResult r = new StreamResult(bout);
        transformer.transform(source, r);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        bout.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                String[] parts = line.split("\\s*,\\s*");
                for (int i = 0; i < parts.length; ++i) {
                    String pkg;
                    int n = parts[i].lastIndexOf(46);
                    if (n <= 0 || (pkg = parts[i].substring(0, n)).startsWith("java.")) continue;
                    refers.add(pkg);
                }
            }
            line = br.readLine();
        }
        br.close();
        return refers;
    }

    protected static String getImportPackages(Set<String> packages) {
        StringBuilder sb = new StringBuilder();
        for (String pkg : packages) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pkg);
        }
        return sb.toString();
    }

    protected static Document parse(URL url) throws Exception {
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(url.toString());
    }

    protected static void copyInputStream(InputStream in, OutputStream out) throws Exception {
        byte[] buffer = new byte[4096];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    static {
        ARTIFACT_MATCHER = Pattern.compile("(.+)(?:-(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[^a-zA-Z0-9](.*))?)(?:\\.([^\\.]+))", 32);
        FUZZY_MODIFIDER = Pattern.compile("(?:\\d+[.-])*(.*)", 32);
    }
}

