/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.threadio;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.apache.felix.gogo.runtime.threadio.Marker;
import org.apache.felix.gogo.runtime.threadio.ThreadInputStream;
import org.apache.felix.gogo.runtime.threadio.ThreadPrintStream;
import org.osgi.service.threadio.ThreadIO;

public class ThreadIOImpl
implements ThreadIO {
    private static final Logger log = Logger.getLogger(ThreadIOImpl.class.getName());
    ThreadPrintStream err = new ThreadPrintStream(System.err);
    ThreadPrintStream out = new ThreadPrintStream(System.out);
    ThreadInputStream in = new ThreadInputStream(System.in);
    ThreadLocal<Marker> current = new InheritableThreadLocal<Marker>();

    public void start() {
        if (System.out instanceof ThreadPrintStream) {
            throw new IllegalStateException("Thread Print Stream already set");
        }
        System.setOut(this.out);
        System.setIn(this.in);
        System.setErr(this.err);
    }

    public void stop() {
        System.setErr(this.err.dflt);
        System.setOut(this.out.dflt);
        System.setIn(this.in.dflt);
    }

    private void checkIO() {
        if (System.in != this.in) {
            log.fine("ThreadIO: eek! who's set System.in=" + System.in);
            System.setIn(this.in);
        }
        if (System.out != this.out) {
            log.fine("ThreadIO: eek! who's set System.out=" + System.out);
            System.setOut(this.out);
        }
        if (System.err != this.err) {
            log.fine("ThreadIO: eek! who's set System.err=" + System.err);
            System.setErr(this.err);
        }
    }

    public void close() {
        this.checkIO();
        Marker top = this.current.get();
        if (top == null) {
            throw new IllegalStateException("No thread io active");
        }
        Marker previous = top.previous;
        if (previous == null) {
            this.in.end();
            this.out.end();
            this.err.end();
        } else {
            this.current.set(previous);
            previous.activate();
        }
    }

    public void setStreams(InputStream in, PrintStream out, PrintStream err) {
        assert (in != null);
        assert (out != null);
        assert (err != null);
        this.checkIO();
        Marker marker = new Marker(this, in, out, err, this.current.get());
        this.current.set(marker);
        marker.activate();
    }
}

