/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.log;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;
import org.apache.felix.karaf.shell.log.LruList;
import org.apache.felix.karaf.shell.log.layout.PatternConverter;
import org.apache.felix.karaf.shell.log.layout.PatternParser;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="display", description="Displays log entries.")
public class DisplayLog
extends OsgiCommandSupport {
    @Option(name="-n", aliases={}, description="Number of entries to display", required=false, multiValued=false)
    protected int entries;
    @Option(name="-p", aliases={}, description="Pattern for formatting the output", required=false, multiValued=false)
    protected String overridenPattern;
    protected String pattern;
    protected LruList events;

    public LruList getEvents() {
        return this.events;
    }

    public void setEvents(LruList events) {
        this.events = events;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    protected Object doExecute() throws Exception {
        PatternConverter cnv = new PatternParser(this.overridenPattern != null ? this.overridenPattern : this.pattern).parse();
        Iterable<PaxLoggingEvent> le = this.events.getElements(this.entries == 0 ? Integer.MAX_VALUE : this.entries);
        StringBuffer sb = new StringBuffer();
        for (PaxLoggingEvent event : le) {
            sb.setLength(0);
            PatternConverter pc = cnv;
            while (pc != null) {
                pc.format(sb, event);
                pc = pc.next;
            }
            System.out.print(sb.toString());
            if (event.getThrowableStrRep() == null) continue;
            for (String r : event.getThrowableStrRep()) {
                System.out.println(r);
            }
        }
        System.out.println();
        return null;
    }
}

