/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.ssh;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jline.Terminal;
import org.apache.felix.karaf.shell.console.Completer;
import org.apache.felix.karaf.shell.console.completer.AggregateCompleter;
import org.apache.felix.karaf.shell.console.jline.Console;
import org.apache.felix.karaf.shell.ssh.SshTerminal;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellFactoryImpl
implements Factory<Command> {
    private CommandProcessor commandProcessor;
    private List<Completer> completers;

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public void setCompleters(List<Completer> completers) {
        this.completers = completers;
    }

    public Command create() {
        return new ShellImpl();
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static Converter getConverter() {
        return new Converter();
    }

    public class LfToCrLfFilterOutputStream
    extends FilterOutputStream {
        private boolean lastWasCr;

        public LfToCrLfFilterOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            if (!this.lastWasCr && b == 10) {
                this.out.write(13);
                this.out.write(10);
            } else {
                this.out.write(b);
            }
            this.lastWasCr = b == 13;
        }
    }

    public static class Converter
    implements org.osgi.service.blueprint.container.Converter {
        public boolean canConvert(Object sourceObject, ReifiedType targetType) {
            return ShellFactoryImpl.class.isAssignableFrom(sourceObject.getClass()) && Factory.class.equals((Object)targetType.getRawClass()) && Command.class.equals((Object)targetType.getActualTypeArgument(0).getRawClass());
        }

        public Object convert(Object sourceObject, ReifiedType targetType) throws Exception {
            return sourceObject;
        }
    }

    public class ShellImpl
    implements Command {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private boolean closed;

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void start(Environment env) throws IOException {
            try {
                Console console = new Console(ShellFactoryImpl.this.commandProcessor, this.in, new PrintStream(new LfToCrLfFilterOutputStream(this.out), true), new PrintStream(new LfToCrLfFilterOutputStream(this.err), true), (Terminal)new SshTerminal(env), (Completer)new AggregateCompleter((Collection)ShellFactoryImpl.this.completers), new Runnable(){

                    public void run() {
                        ShellImpl.this.destroy();
                    }
                });
                CommandSession session = console.getSession();
                session.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
                for (Map.Entry e : env.getEnv().entrySet()) {
                    session.put((String)e.getKey(), e.getValue());
                }
                new Thread((Runnable)console).start();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to start shell").initCause(e);
            }
        }

        public void destroy() {
            if (!this.closed) {
                this.closed = true;
                ShellFactoryImpl.close(new Closeable[]{this.in, this.out, this.err});
                this.callback.onExit(0);
            }
        }
    }
}

