/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.HashMap;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class AppenderTracker
extends ServiceTracker {
    private HashMap m_appenders = new HashMap();

    public AppenderTracker(BundleContext bundleContext) {
        super(bundleContext, PaxAppender.class.getName(), null);
    }

    public Object addingService(ServiceReference serviceReference) {
        Object name = serviceReference.getProperty("org.ops4j.pax.logging.appender.name");
        Object appender = super.addingService(serviceReference);
        this.m_appenders.put(name, appender);
        return appender;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
        Object name = serviceReference.getProperty("org.ops4j.pax.logging.appender.name");
        this.m_appenders.put(name, object);
        super.modifiedService(serviceReference, object);
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        Object name = serviceReference.getProperty("org.ops4j.pax.logging.appender.name");
        this.m_appenders.remove(name);
        super.removedService(serviceReference, object);
    }

    public PaxAppender getAppender(String name) {
        return new PaxAppenderProxy(name);
    }

    public class PaxAppenderProxy
    implements PaxAppender {
        private final String m_name;

        public PaxAppenderProxy(String name) {
            this.m_name = name;
        }

        public void doAppend(PaxLoggingEvent event) {
            PaxAppender appender = (PaxAppender)AppenderTracker.this.m_appenders.get(this.m_name);
            if (appender != null) {
                appender.doAppend(event);
            }
        }
    }
}

