/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.HashSet;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.log.LogService;

public class DropAllResourcesCommand
extends Command {
    private final CommitResourceCommand m_commitCommand;

    public DropAllResourcesCommand(CommitResourceCommand commitCommand) {
        this.m_commitCommand = commitCommand;
    }

    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        this.addRollback(new RollbackCommitAction(session));
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        LogService log = session.getLog();
        HashSet<String> resourceProcessors = new HashSet<String>();
        ResourceInfoImpl[] orderedTargetResources = target.getOrderedResourceInfos();
        for (int i = orderedTargetResources.length - 1; i >= 0; --i) {
            ResourceInfoImpl resourceInfo = orderedTargetResources[i];
            if (!resourceInfo.isProcessedResource()) {
                session.getLog().log(3, "Ignoring non-processed resource: " + resourceInfo.getPath());
                continue;
            }
            String rpName = resourceInfo.getResourceProcessor();
            String path = resourceInfo.getPath();
            if (!resourceProcessors.add(rpName)) continue;
            ServiceReference ref = target.getResourceProcessor(path);
            if (ref == null) {
                log.log(1, "Failed to find resource processor for '" + rpName + "'!");
                throw new DeploymentException(464, "Failed to find resource processor '" + rpName + "'!");
            }
            ResourceProcessor resourceProcessor = (ResourceProcessor)context.getService(ref);
            if (resourceProcessor == null) {
                log.log(1, "Failed to find resource processor for '" + rpName + "'!");
                throw new DeploymentException(464, "Failed to find resource processor '" + rpName + "'!");
            }
            try {
                if (this.m_commitCommand.addResourceProcessor(resourceProcessor)) {
                    resourceProcessor.begin(session);
                }
                resourceProcessor.dropAllResources();
                continue;
            }
            catch (Exception e) {
                log.log(1, "Failed to drop all resources for resource processor '" + rpName + "'!", (Throwable)e);
                throw new DeploymentException(463, "Failed to drop all resources for resource processor '" + rpName + "'!", e);
            }
        }
    }

    private class RollbackCommitAction
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;

        public RollbackCommitAction(DeploymentSessionImpl session) {
            this.m_session = session;
        }

        protected void doRun() {
            DropAllResourcesCommand.this.m_commitCommand.rollback(this.m_session);
        }
    }
}

