/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.task;

import java.io.File;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.felix.ipojo.task.AntReporter;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class IPojoTask
extends Task {
    private File m_metadata;
    private File m_input;
    private File m_output;
    private File m_directory;
    private File m_manifest;
    private boolean m_ignoreAnnotations = false;
    private boolean m_ignoreLocalXSD = false;
    private Path m_classpath;

    public void setMetadata(File meta) {
        this.m_metadata = meta;
    }

    public void setManifest(File manifest) {
        this.m_manifest = manifest;
    }

    public void setInput(File in) {
        this.m_input = in;
    }

    public void setDir(File dir) {
        this.m_directory = dir;
    }

    public void setOutput(File out) {
        this.m_output = out;
    }

    public void setIgnoreAnnotations(boolean flag) {
        this.m_ignoreAnnotations = flag;
    }

    public void setIgnoreEmbeddedSchemas(boolean flag) {
        this.m_ignoreLocalXSD = flag;
    }

    public void execute() {
        if (this.m_input == null && this.m_directory == null) {
            throw new BuildException("Neither input bundle nor directory specified");
        }
        if (this.m_input != null && !this.m_input.exists()) {
            throw new BuildException("The input bundle " + this.m_input.getAbsolutePath() + " does not exist");
        }
        if (this.m_directory != null && !this.m_directory.exists()) {
            throw new BuildException("The input directory " + this.m_directory.getAbsolutePath() + " does not exist");
        }
        if (this.m_directory != null && !this.m_directory.isDirectory()) {
            throw new BuildException("The input directory " + this.m_directory.getAbsolutePath() + " is not a directory");
        }
        if (this.m_input != null) {
            this.log("Input bundle file : " + this.m_input.getAbsolutePath());
        } else {
            this.log("Input directory : " + this.m_directory.getAbsolutePath());
        }
        if (this.m_manifest != null) {
            if (this.m_input != null) {
                throw new BuildException("The manifest location cannot be used when manipulating an existing bundle");
            }
            if (!this.m_manifest.exists()) {
                throw new BuildException("The manifest file " + this.m_manifest.getAbsolutePath() + " does not exist");
            }
        }
        if (this.m_metadata == null) {
            this.m_metadata = new File("./metadata.xml");
            if (!this.m_metadata.exists()) {
                if (this.m_ignoreAnnotations) {
                    this.log("No metadata file found & annotations ignored : nothing to do");
                    return;
                }
                this.log("No metadata file found - trying to use only annotations");
                this.m_metadata = null;
            } else {
                this.log("Metadata file : " + this.m_metadata.getAbsolutePath());
            }
        } else {
            if (!this.m_metadata.exists()) {
                throw new BuildException("No metadata file found - the file " + this.m_metadata.getAbsolutePath() + " does not exist");
            }
            if (this.m_metadata.isDirectory()) {
                this.log("Metadata directory : " + this.m_metadata.getAbsolutePath());
            } else {
                this.log("Metadata file : " + this.m_metadata.getAbsolutePath());
            }
        }
        this.initializeSaxDriver();
        this.log("Start manipulation");
        if (this.m_input != null) {
            boolean r;
            if (this.m_output == null) {
                this.m_output = new File("./_out.jar");
            }
            if (this.m_output.exists() && !(r = this.m_output.delete())) {
                throw new BuildException("The file " + this.m_output.getAbsolutePath() + " cannot be deleted");
            }
        }
        AntReporter reporter = new AntReporter(this.getProject());
        Pojoization pojo = new Pojoization(reporter);
        if (this.m_ignoreAnnotations) {
            pojo.disableAnnotationProcessing();
        }
        if (!this.m_ignoreLocalXSD) {
            pojo.setUseLocalXSD();
        }
        Path classpath = this.getClasspath();
        classpath.addJavaRuntime();
        if (this.m_classpath == null) {
            this.m_classpath = this.createClasspath();
        }
        Path element = this.m_classpath.createPath();
        if (this.m_input != null) {
            element.setLocation(this.m_input.getAbsoluteFile());
        } else if (this.m_directory != null) {
            element.setLocation(this.m_directory.getAbsoluteFile());
        }
        this.m_classpath.add(element);
        AntClassLoader loader = this.getProject().createClassLoader(this.getClasspath());
        if (this.m_input != null) {
            pojo.pojoization(this.m_input, this.m_output, this.m_metadata, (ClassLoader)loader);
        } else {
            pojo.directoryPojoization(this.m_directory, this.m_metadata, this.m_manifest, (ClassLoader)loader);
        }
        for (int i = 0; i < reporter.getWarnings().size(); ++i) {
            this.log(reporter.getWarnings().get(i), 1);
        }
        if (reporter.getErrors().size() > 0) {
            throw new BuildException(reporter.getErrors().get(0));
        }
        if (this.m_input != null) {
            String out;
            if (this.m_output.getName().equals("_out.jar")) {
                if (this.m_input.delete()) {
                    if (!this.m_output.renameTo(this.m_input)) {
                        this.log("Cannot rename the output jar to " + this.m_input.getAbsolutePath(), 1);
                    }
                } else {
                    this.log("Cannot delete the input file : " + this.m_input.getAbsolutePath(), 1);
                }
                out = this.m_input.getAbsolutePath();
            } else {
                out = this.m_output.getAbsolutePath();
            }
            this.log("Bundle manipulation - SUCCESS");
            this.log("Output file : " + out);
        } else {
            this.log("Manipulation - SUCCESS");
            this.log("Output files : " + this.m_directory.getAbsolutePath());
            if (this.m_manifest != null) {
                this.log("Manifest : " + this.m_manifest.getAbsolutePath());
            }
        }
    }

    private void initializeSaxDriver() {
        String version = System.getProperty("java.vm.version");
        if (version.startsWith("1.4")) {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        }
    }

    public synchronized void setClasspath(Path classpath) {
        if (this.m_classpath == null) {
            this.m_classpath = this.createClasspath();
        }
        this.m_classpath.append(classpath);
    }

    public synchronized Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.getProject());
        }
        return this.m_classpath.createPath();
    }

    public void setClasspathRef(Reference pathRef) {
        this.createClasspath().setRefid(pathRef);
    }

    public Path getClasspath() {
        return this.m_classpath;
    }
}

