/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.InetAddress;
import org.cybergarage.upnp.device.SearchListener;
import org.cybergarage.upnp.ssdp.HTTPMUSocket;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.ListenerList;

public class SSDPSearchSocket
extends HTTPMUSocket
implements Runnable {
    private ListenerList deviceSearchListenerList = new ListenerList();
    private Thread deviceSearchThread = null;

    public SSDPSearchSocket(String bindAddr, int port, String multicast) {
        this.open(bindAddr, multicast);
    }

    public SSDPSearchSocket(InetAddress bindAddr) {
        this.open("239.255.255.250", SSDP.PORT, bindAddr);
    }

    public boolean open(String bind, String multicast) {
        return this.open(multicast, SSDP.PORT, bind);
    }

    public boolean open(String bindAddr) {
        String addr = "239.255.255.250";
        return this.open(addr, SSDP.PORT, bindAddr);
    }

    public void addSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.add(listener);
    }

    public void removeSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.remove(listener);
    }

    public void performSearchListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceSearchListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            SearchListener listener = (SearchListener)this.deviceSearchListenerList.get(n);
            listener.deviceSearchReceived(ssdpPacket);
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.deviceSearchThread == thisThread) {
            Thread.yield();
            SSDPPacket packet = this.receive();
            if (packet == null || !packet.isDiscover()) continue;
            this.performSearchListener(packet);
        }
    }

    public void start() {
        StringBuffer name = new StringBuffer("Cyber.SSDPSearchSocket/");
        name.append(this.getLocalAddress()).append(':');
        name.append(this.getLocalPort()).append(" -> ");
        name.append(this.getMulticastAddress()).append(':');
        name.append(this.getMulticastPort());
        this.deviceSearchThread = new Thread((Runnable)this, name.toString());
        this.deviceSearchThread.start();
    }

    public void stop() {
        this.close();
        this.deviceSearchThread = null;
    }
}

