/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.xml;

public class XML {
    public static final String CONTENT_TYPE = "text/xml; charset=\"utf-8\"";
    public static final String CHARSET_UTF8 = "utf-8";

    private static final String escapeXMLChars(String input, boolean quote) {
        if (input == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        int oldsize = input.length();
        char[] old = new char[oldsize];
        input.getChars(0, oldsize, old, 0);
        int selstart = 0;
        String entity = null;
        for (int i = 0; i < oldsize; ++i) {
            switch (old[i]) {
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    if (quote) {
                        entity = "&apos;";
                        break;
                    }
                }
                case '\"': {
                    if (!quote) break;
                    entity = "&quot;";
                }
            }
            if (entity == null) continue;
            out.append(old, selstart, i - selstart);
            out.append(entity);
            selstart = i + 1;
            entity = null;
        }
        if (selstart == 0) {
            return input;
        }
        out.append(old, selstart, oldsize - selstart);
        return out.toString();
    }

    public static final String escapeXMLChars(String input) {
        return XML.escapeXMLChars(input, true);
    }

    public static final String unescapeXMLChars(String input) {
        if (input == null) {
            return null;
        }
        String outStr = XML.replaceAll(input, "&amp;", "&");
        outStr = XML.replaceAll(outStr, "&lt;", "<");
        outStr = XML.replaceAll(outStr, "&gt;", ">");
        outStr = XML.replaceAll(outStr, "&apos;", "'");
        outStr = XML.replaceAll(outStr, "&quot;", "\"");
        return outStr;
    }

    private static String replaceAll(String original, String search, String replace) {
        int pos = -1;
        StringBuffer result = new StringBuffer();
        while ((pos = original.indexOf(search)) != -1) {
            result.append(original.substring(0, pos)).append(replace);
            original = original.substring(pos + search.length());
        }
        return result.append(original).toString();
    }
}

