/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl;

import java.util.ArrayList;
import java.util.List;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;

final class RoleChecker {
    RoleChecker() {
    }

    public boolean isImpliedBy(Role role, Role impliedRole) {
        if (role instanceof Group) {
            return this.isGroupImpliedBy((Group)role, impliedRole, new ArrayList());
        }
        return this.isRoleImpliedBy(role, impliedRole);
    }

    private boolean isGroupImpliedBy(Group group, Role impliedRole, List seenGroups) {
        int i;
        Role[] basicRoles = group.getMembers();
        Role[] requiredRoles = group.getRequiredMembers();
        boolean isImplied = true;
        for (i = 0; requiredRoles != null && isImplied && i < requiredRoles.length; ++i) {
            Role requiredRole = requiredRoles[i];
            if (seenGroups.contains(requiredRole)) {
                return false;
            }
            if (requiredRole instanceof Group) {
                seenGroups.add(requiredRole);
                isImplied = this.isGroupImpliedBy((Group)requiredRole, impliedRole, seenGroups);
                continue;
            }
            isImplied = this.isRoleImpliedBy(requiredRole, impliedRole);
        }
        if (!isImplied) {
            return false;
        }
        isImplied = false;
        for (i = 0; basicRoles != null && !isImplied && i < basicRoles.length; ++i) {
            Role basicRole = basicRoles[i];
            if (seenGroups.contains(basicRole)) {
                return false;
            }
            if (basicRole instanceof Group) {
                seenGroups.add(basicRole);
                isImplied = this.isGroupImpliedBy((Group)basicRole, impliedRole, seenGroups);
                continue;
            }
            isImplied = this.isRoleImpliedBy(basicRole, impliedRole);
        }
        return isImplied;
    }

    private boolean isRoleImpliedBy(Role role, Role impliedRole) {
        return "user.anyone".equals(role.getName()) || impliedRole != null && impliedRole.getName().equals(role.getName());
    }
}

