/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class Pool<T> {
    private final ArrayBlockingQueue<T> pool;
    private final Recycler<T> recycler;
    private final int poolCapacity;
    private int poolSize;

    public Pool(int poolCapacity) {
        this.pool = new ArrayBlockingQueue(poolCapacity);
        this.recycler = this::addBack;
        this.poolCapacity = poolCapacity;
        this.poolSize = 0;
    }

    public Recycler<T> recycler() {
        return this.recycler;
    }

    public synchronized void add(T object) {
        if (this.poolSize >= this.poolCapacity) {
            throw new IllegalStateException("No space left in pool");
        }
        ++this.poolSize;
        this.addBack(object);
    }

    public T pollEntry() throws InterruptedException {
        return this.pool.take();
    }

    @Nullable
    public T tryPollEntry() {
        return this.pool.poll();
    }

    void addBack(T object) {
        this.pool.add(object);
    }

    @FunctionalInterface
    public static interface Recycler<T> {
        public void recycle(T var1);
    }
}

