/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class SingleJobJobGraphStore
implements JobGraphStore {
    private final JobGraph jobGraph;

    public SingleJobJobGraphStore(JobGraph jobGraph) {
        this.jobGraph = Preconditions.checkNotNull(jobGraph);
    }

    @Override
    public void start(JobGraphStore.JobGraphListener jobGraphListener) throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public JobGraph recoverJobGraph(JobID jobId) throws Exception {
        if (this.jobGraph.getJobID().equals(jobId)) {
            return this.jobGraph;
        }
        throw new FlinkException("Could not recover job graph " + jobId + '.');
    }

    @Override
    public void putJobGraph(JobGraph jobGraph) throws Exception {
        if (!Objects.equals(this.jobGraph.getJobID(), jobGraph.getJobID())) {
            throw new FlinkException("Cannot put additional jobs into this submitted job graph store.");
        }
    }

    @Override
    public Collection<JobID> getJobIds() {
        return Collections.singleton(this.jobGraph.getJobID());
    }
}

