/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.internal.intercepted;

import io.micronaut.aop.Around;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBinding;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.internal.intercepted.CompletionStageInterceptedMethod;
import io.micronaut.aop.internal.intercepted.KotlinInterceptedMethod;
import io.micronaut.aop.internal.intercepted.PublisherInterceptedMethod;
import io.micronaut.aop.internal.intercepted.SynchronousInterceptedMethod;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.ReturnType;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;

@Internal
public final class InterceptedMethodUtil {
    private InterceptedMethodUtil() {
    }

    public static InterceptedMethod of(MethodInvocationContext<?, ?> context) {
        if (context.isSuspend()) {
            KotlinInterceptedMethod kotlinInterceptedMethod = KotlinInterceptedMethod.of(context);
            if (kotlinInterceptedMethod != null) {
                return kotlinInterceptedMethod;
            }
            return new SynchronousInterceptedMethod(context);
        }
        ReturnType returnType = context.getReturnType();
        Class returnTypeClass = returnType.getType();
        if (returnTypeClass == Void.TYPE || returnTypeClass == String.class) {
            return new SynchronousInterceptedMethod(context);
        }
        if (CompletionStage.class.isAssignableFrom(returnTypeClass) || Future.class.isAssignableFrom(returnTypeClass)) {
            return new CompletionStageInterceptedMethod(context);
        }
        if (PublisherInterceptedMethod.isConvertibleToPublisher(returnTypeClass)) {
            return new PublisherInterceptedMethod(context);
        }
        return new SynchronousInterceptedMethod(context);
    }

    public static AnnotationValue<?>[] resolveInterceptorBinding(AnnotationMetadata annotationMetadata, InterceptorKind interceptorKind) {
        List interceptorBindings = annotationMetadata.getAnnotationValuesByType(InterceptorBinding.class);
        if (!interceptorBindings.isEmpty()) {
            return (AnnotationValue[])interceptorBindings.stream().filter(av -> {
                InterceptorKind kind = av.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND);
                return kind == interceptorKind;
            }).toArray(AnnotationValue[]::new);
        }
        return AnnotationUtil.ZERO_ANNOTATION_VALUES;
    }

    public static boolean hasAroundStereotype(@Nullable AnnotationMetadata annotationMetadata) {
        return InterceptedMethodUtil.hasAround(annotationMetadata, annMetadata -> annMetadata.hasStereotype(Around.class), annMetdata -> annMetdata.getAnnotationValuesByType(InterceptorBinding.class));
    }

    public static boolean hasDeclaredAroundAdvice(@Nullable AnnotationMetadata annotationMetadata) {
        return InterceptedMethodUtil.hasAround(annotationMetadata, annMetadata -> annMetadata.hasDeclaredStereotype(Around.class), annMetdata -> annMetdata.getDeclaredAnnotationValuesByType(InterceptorBinding.class));
    }

    private static boolean hasAround(@Nullable AnnotationMetadata annotationMetadata, @NonNull Predicate<AnnotationMetadata> hasFunction, @NonNull Function<AnnotationMetadata, List<AnnotationValue<InterceptorBinding>>> interceptorBindingsFunction) {
        if (annotationMetadata == null) {
            return false;
        }
        if (hasFunction.test(annotationMetadata)) {
            return true;
        }
        if (annotationMetadata.hasDeclaredStereotype("io.micronaut.aop.InterceptorBindingDefinitions")) {
            return interceptorBindingsFunction.apply(annotationMetadata).stream().anyMatch(av -> av.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND) == InterceptorKind.AROUND);
        }
        return false;
    }
}

