/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.lang.CancelHandle;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;

final class CancelHandleImpl
implements CancelHandle {
    private final CompletableFuture<Void> cancelFut = new CompletableFuture();
    private final CancellationTokenImpl token = new CancellationTokenImpl(this);

    CancelHandleImpl() {
    }

    @Override
    public void cancel() {
        this.doCancelAsync();
        this.cancelFut.join();
    }

    @Override
    public CompletableFuture<Void> cancelAsync() {
        this.doCancelAsync();
        return this.cancelFut.copy();
    }

    @Override
    public boolean isCancelled() {
        return this.token.isCancelled();
    }

    @Override
    public CancellationToken token() {
        return this.token;
    }

    private void doCancelAsync() {
        this.token.cancel();
    }

    static final class CancellationTokenImpl
    implements CancellationToken {
        private final ArrayDeque<Cancellation> cancellations = new ArrayDeque();
        private final CancelHandleImpl handle;
        private final Object mux = new Object();
        private volatile CompletableFuture<Void> cancelFut;

        CancellationTokenImpl(CancelHandleImpl handle) {
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addCancelAction(Runnable action, CompletableFuture<?> fut) {
            Cancellation cancellation = new Cancellation(action, fut);
            if (this.cancelFut != null) {
                cancellation.run();
            } else {
                Object object = this.mux;
                synchronized (object) {
                    if (this.cancelFut == null) {
                        this.cancellations.add(cancellation);
                        return;
                    }
                }
                cancellation.run();
            }
        }

        boolean isCancelled() {
            return this.cancelFut != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            if (this.cancelFut != null) {
                return;
            }
            Object object = this.mux;
            synchronized (object) {
                if (this.cancelFut != null) {
                    return;
                }
                CompletableFuture[] futures = (CompletableFuture[])this.cancellations.stream().map(c -> c.completionFut).toArray(CompletableFuture[]::new);
                this.cancelFut = CompletableFuture.allOf(futures).whenComplete((r, t) -> this.handle.cancelFut.complete(null));
            }
            Throwable error = null;
            for (Cancellation cancellation : this.cancellations) {
                try {
                    cancellation.run();
                }
                catch (Throwable t2) {
                    if (error == null) {
                        error = new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to cancel an operation");
                    }
                    error.addSuppressed(t2);
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }

    private static class Cancellation {
        private final Runnable cancelAction;
        private final CompletableFuture<?> completionFut;

        private Cancellation(Runnable cancelAction, CompletableFuture<?> completionFut) {
            this.cancelAction = cancelAction;
            this.completionFut = completionFut;
        }

        private void run() {
            this.cancelAction.run();
        }
    }
}

