/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfoMetrics;
import org.apache.iotdb.db.service.metrics.MetricService;

public class TsFileProcessorInfo {
    private StorageGroupInfo storageGroupInfo;
    private long memCost;

    public TsFileProcessorInfo(StorageGroupInfo storageGroupInfo) {
        this.storageGroupInfo = storageGroupInfo;
        this.memCost = 0L;
        if (null != storageGroupInfo.getVirtualStorageGroupProcessor()) {
            MetricService.getInstance().addMetricSet(new TsFileProcessorInfoMetrics(storageGroupInfo.getVirtualStorageGroupProcessor().getLogicalStorageGroupName(), this));
        }
    }

    public void addTSPMemCost(long cost) {
        this.memCost += cost;
        this.storageGroupInfo.addStorageGroupMemCost(cost);
    }

    public void releaseTSPMemCost(long cost) {
        this.storageGroupInfo.releaseStorageGroupMemCost(cost);
        this.memCost -= cost;
    }

    public void clear() {
        this.storageGroupInfo.releaseStorageGroupMemCost(this.memCost);
        this.memCost = 0L;
    }

    public long getMemCost() {
        return this.memCost;
    }
}

