/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch;

import java.util.HashSet;
import java.util.LinkedList;
import org.fusesource.hawtdispatch.EventAggregator;
import org.fusesource.hawtdispatch.OrderedEventAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAggregators {
    public static final EventAggregator<Integer, Integer> INTEGER_ADD = new EventAggregator<Integer, Integer>(){

        @Override
        public Integer mergeEvent(Integer previous, Integer event) {
            if (previous == null) {
                return event;
            }
            return previous + event;
        }

        @Override
        public Integer mergeEvents(Integer previous, Integer events) {
            return previous + events;
        }
    };
    public static final EventAggregator<Long, Long> LONG_ADD = new EventAggregator<Long, Long>(){

        @Override
        public Long mergeEvent(Long previous, Long event) {
            if (previous == null) {
                return event;
            }
            return previous + event;
        }

        @Override
        public Long mergeEvents(Long previous, Long events) {
            return previous + events;
        }
    };
    public static final EventAggregator<Integer, Integer> INTEGER_OR = new EventAggregator<Integer, Integer>(){

        @Override
        public Integer mergeEvent(Integer previous, Integer event) {
            if (previous == null) {
                return event;
            }
            return previous | event;
        }

        @Override
        public Integer mergeEvents(Integer previous, Integer events) {
            return previous | events;
        }
    };
    public static final EventAggregator<Long, Long> LONG_OR = new EventAggregator<Long, Long>(){

        @Override
        public Long mergeEvent(Long previous, Long event) {
            if (previous == null) {
                return event;
            }
            return previous | event;
        }

        @Override
        public Long mergeEvents(Long previous, Long events) {
            return previous | events;
        }
    };

    public static <T> EventAggregator<T, LinkedList<T>> linkedList() {
        return new OrderedEventAggregator<T, LinkedList<T>>(){

            @Override
            public LinkedList<T> mergeEvent(LinkedList<T> previous, T event) {
                if (previous == null) {
                    previous = new LinkedList();
                }
                previous.add(event);
                return previous;
            }

            @Override
            public LinkedList<T> mergeEvents(LinkedList<T> previous, LinkedList<T> events) {
                previous.addAll(events);
                return previous;
            }
        };
    }

    public static <T> EventAggregator<T, HashSet<T>> hashSet() {
        return new EventAggregator<T, HashSet<T>>(){

            @Override
            public HashSet<T> mergeEvent(HashSet<T> previous, T event) {
                if (previous == null) {
                    previous = new HashSet();
                }
                previous.add(event);
                return previous;
            }

            @Override
            public HashSet<T> mergeEvents(HashSet<T> previous, HashSet<T> events) {
                previous.addAll(events);
                return previous;
            }

            public boolean ordered() {
                return false;
            }
        };
    }
}

