/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.coordinator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.ChangeMembershipException;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.UnknownLogTypeException;
import org.apache.iotdb.cluster.exception.UnsupportedPlanException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.ClusterPlanRouter;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.cluster.utils.PartitionUtils;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.BatchPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coordinator {
    private static final Logger logger = LoggerFactory.getLogger(Coordinator.class);
    private MetaGroupMember metaGroupMember;
    private String name;
    private Node thisNode;
    private ClusterPlanRouter router;
    private static final String MSG_MULTIPLE_ERROR = "The following errors occurred when executing the query, please retry or contact the DBA: ";

    public Coordinator(MetaGroupMember metaGroupMember) {
        this.linkMetaGroupMember(metaGroupMember);
    }

    public Coordinator() {
    }

    public void linkMetaGroupMember(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
        if (metaGroupMember.getCoordinator() != null && metaGroupMember.getCoordinator() != this) {
            logger.warn("MetadataGroupMember linked inconsistent Coordinator, will correct it.");
            metaGroupMember.setCoordinator(this);
        }
        this.name = metaGroupMember.getName();
        this.thisNode = metaGroupMember.getThisNode();
    }

    public void setRouter(ClusterPlanRouter router) {
        this.router = router;
    }

    public TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        TSStatus result;
        long startTime = Timer.Statistic.COORDINATOR_EXECUTE_NON_QUERY.getOperationStartTime();
        if (PartitionUtils.isLocalNonQueryPlan(plan)) {
            result = this.executeNonQueryLocally(plan);
        } else if (PartitionUtils.isGlobalMetaPlan(plan)) {
            result = this.metaGroupMember.processNonPartitionedMetaPlan(plan);
        } else if (PartitionUtils.isGlobalDataPlan(plan)) {
            result = this.processNonPartitionedDataPlan(plan);
        } else {
            try {
                result = this.processPartitionedPlan(plan);
            }
            catch (UnsupportedPlanException e) {
                return StatusUtils.getStatus(StatusUtils.UNSUPPORTED_OPERATION, e.getMessage());
            }
        }
        Timer.Statistic.COORDINATOR_EXECUTE_NON_QUERY.calOperationCostTimeFromStart(startTime);
        return result;
    }

    private TSStatus executeNonQueryLocally(PhysicalPlan plan) {
        boolean execRet;
        try {
            execRet = this.metaGroupMember.getLocalExecutor().processNonQuery(plan);
        }
        catch (QueryProcessException e) {
            if (e.getErrorCode() != TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()) {
                logger.debug("meet error while processing non-query. ", (Throwable)e);
            } else {
                logger.warn("meet error while processing non-query. ", (Throwable)e);
            }
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        return execRet ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
    }

    private TSStatus processNonPartitionedDataPlan(PhysicalPlan plan) {
        try {
            if (plan instanceof DeleteTimeSeriesPlan) {
                ((CMManager)IoTDB.metaManager).convertToFullPaths(plan);
            } else {
                this.metaGroupMember.syncLeaderWithConsistencyCheck(true);
            }
        }
        catch (PathNotExistException e) {
            if (plan.getPaths().isEmpty()) {
                return StatusUtils.getStatus(StatusUtils.TIMESERIES_NOT_EXIST_ERROR, e.getMessage());
            }
        }
        catch (CheckConsistencyException e) {
            logger.debug("Forwarding global data plan {} to meta leader {}", (Object)plan, (Object)this.metaGroupMember.getLeader());
            this.metaGroupMember.waitLeader();
            return this.metaGroupMember.forwardPlan(plan, this.metaGroupMember.getLeader(), null);
        }
        try {
            this.createSchemaIfNecessary(plan);
        }
        catch (CheckConsistencyException | MetadataException e) {
            logger.error("{}: Cannot find storage groups for {}", (Object)this.name, (Object)plan);
            return StatusUtils.NO_STORAGE_GROUP;
        }
        List<PartitionGroup> globalGroups = this.metaGroupMember.getPartitionTable().getGlobalGroups();
        logger.debug("Forwarding global data plan {} to {} groups", (Object)plan, (Object)globalGroups.size());
        return this.forwardPlan(globalGroups, plan);
    }

    public void createSchemaIfNecessary(PhysicalPlan plan) throws MetadataException, CheckConsistencyException {
        if (plan instanceof SetTemplatePlan) {
            try {
                IoTDB.metaManager.getBelongedStorageGroup(new PartialPath(((SetTemplatePlan)plan).getPrefixPath()));
            }
            catch (IllegalPathException illegalPathException) {
            }
            catch (StorageGroupNotSetException e) {
                ((CMManager)IoTDB.metaManager).createSchema(plan);
            }
        }
    }

    public TSStatus processPartitionedPlan(PhysicalPlan plan) throws UnsupportedPlanException {
        Map<PhysicalPlan, PartitionGroup> planGroupMap;
        logger.debug("{}: Received a partitioned plan {}", (Object)this.name, (Object)plan);
        if (this.metaGroupMember.getPartitionTable() == null) {
            logger.debug("{}: Partition table is not ready", (Object)this.name);
            return StatusUtils.PARTITION_TABLE_NOT_READY;
        }
        if (!this.checkPrivilegeForBatchExecution(plan)) {
            return this.concludeFinalStatus(plan, plan.getPaths().size(), true, false, false, null, Collections.emptyList());
        }
        try {
            planGroupMap = this.splitPlan(plan);
        }
        catch (CheckConsistencyException checkConsistencyException) {
            return StatusUtils.getStatus(StatusUtils.CONSISTENCY_FAILURE, checkConsistencyException.getMessage());
        }
        if (planGroupMap == null || planGroupMap.isEmpty()) {
            if ((plan instanceof InsertPlan || plan instanceof CreateTimeSeriesPlan || plan instanceof CreateAlignedTimeSeriesPlan || plan instanceof CreateMultiTimeSeriesPlan) && ClusterDescriptor.getInstance().getConfig().isEnableAutoCreateSchema()) {
                logger.debug("{}: No associated storage group found for {}, auto-creating", (Object)this.name, (Object)plan);
                try {
                    ((CMManager)IoTDB.metaManager).createSchema(plan);
                    return this.processPartitionedPlan(plan);
                }
                catch (CheckConsistencyException | MetadataException e) {
                    logger.error(String.format("Failed to set storage group or create timeseries, because %s", e));
                }
            }
            logger.error("{}: Cannot find storage groups for {}", (Object)this.name, (Object)plan);
            return StatusUtils.NO_STORAGE_GROUP;
        }
        logger.debug("{}: The data groups of {} are {}", new Object[]{this.name, plan, planGroupMap});
        return this.forwardPlan(planGroupMap, plan);
    }

    private boolean checkPrivilegeForBatchExecution(PhysicalPlan plan) {
        if (plan instanceof BatchPlan) {
            return ((BatchPlan)plan).getResults().size() != plan.getPaths().size();
        }
        return true;
    }

    private TSStatus forwardPlan(List<PartitionGroup> partitionGroups, PhysicalPlan plan) {
        TSStatus status;
        ArrayList<String> errorCodePartitionGroups = new ArrayList<String>();
        for (PartitionGroup partitionGroup : partitionGroups) {
            if (partitionGroup.contains(this.thisNode)) {
                status = this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader()).executeNonQueryPlan(plan);
                logger.debug("Execute {} in a local group of {} with status {}", new Object[]{plan, partitionGroup.getHeader(), status});
            } else {
                status = this.forwardPlan(plan, partitionGroup);
                logger.debug("Forward {} to a remote group of {} with status {}", new Object[]{plan, partitionGroup.getHeader(), status});
            }
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || plan instanceof SetTemplatePlan && status.getCode() == TSStatusCode.DUPLICATED_TEMPLATE.getStatusCode() || plan instanceof DeleteTimeSeriesPlan && status.getCode() == TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()) continue;
            errorCodePartitionGroups.add(String.format("[%s@%s:%s]", status.getCode(), partitionGroup.getHeader(), status.getMessage()));
        }
        status = errorCodePartitionGroups.isEmpty() ? StatusUtils.OK : StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, MSG_MULTIPLE_ERROR + errorCodePartitionGroups);
        logger.debug("{}: executed {} with answer {}", new Object[]{this.name, plan, status});
        return status;
    }

    public void sendLogToAllDataGroups(Log log) throws ChangeMembershipException {
        if (logger.isDebugEnabled()) {
            logger.debug("Send log {} to all data groups: start", (Object)log);
        }
        Map<PhysicalPlan, PartitionGroup> planGroupMap = this.router.splitAndRouteChangeMembershipLog(log);
        CopyOnWriteArrayList errorCodePartitionGroups = new CopyOnWriteArrayList();
        CountDownLatch counter = new CountDownLatch(planGroupMap.size());
        for (Map.Entry<PhysicalPlan, PartitionGroup> entry : planGroupMap.entrySet()) {
            this.metaGroupMember.getAppendLogThreadPool().submit(() -> this.forwardChangeMembershipPlan(log, entry, errorCodePartitionGroups, counter));
        }
        try {
            counter.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ChangeMembershipException(String.format("Can not wait all data groups to apply %s", log));
        }
        if (!errorCodePartitionGroups.isEmpty()) {
            throw new ChangeMembershipException(String.format("Apply %s failed with status {%s}", log, errorCodePartitionGroups));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Send log {} to all data groups: end", (Object)log);
        }
    }

    private void forwardChangeMembershipPlan(Log log, Map.Entry<PhysicalPlan, PartitionGroup> entry, List<String> errorCodePartitionGroups, CountDownLatch counter) {
        int retryTime = 0;
        long startTime = System.currentTimeMillis();
        try {
            while (true) {
                block13: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Send change membership log {} to data group {}, retry time: {}", new Object[]{log, entry.getValue(), retryTime});
                    }
                    try {
                        TSStatus status = this.forwardToSingleGroup(entry);
                        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) break block13;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Success to send change membership log {} to data group {}", (Object)log, (Object)entry.getValue());
                        }
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        errorCodePartitionGroups.add(e.getMessage());
                        return;
                    }
                }
                long cost = System.currentTimeMillis() - startTime;
                if (cost > (long)ClusterDescriptor.getInstance().getConfig().getWriteOperationTimeoutMS()) {
                    errorCodePartitionGroups.add(String.format("Forward change membership log %s to data group %s", log, entry.getValue()));
                    return;
                }
                Thread.sleep(10L);
                ++retryTime;
            }
        }
        finally {
            counter.countDown();
        }
    }

    private Map<PhysicalPlan, PartitionGroup> splitPlan(PhysicalPlan plan) throws UnsupportedPlanException, CheckConsistencyException {
        Map<PhysicalPlan, PartitionGroup> planGroupMap = null;
        try {
            planGroupMap = this.router.splitAndRoutePlan(plan);
        }
        catch (StorageGroupNotSetException e) {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(true);
            try {
                planGroupMap = this.router.splitAndRoutePlan(plan);
            }
            catch (UnknownLogTypeException | MetadataException throwable) {}
        }
        catch (UnknownLogTypeException | MetadataException e) {
            logger.error("Cannot route plan {}", (Object)plan, (Object)e);
        }
        logger.debug("route plan {} with partitionGroup {}", (Object)plan, planGroupMap);
        return planGroupMap;
    }

    private TSStatus forwardPlan(Map<PhysicalPlan, PartitionGroup> planGroupMap, PhysicalPlan plan) {
        TSStatus status = plan instanceof InsertMultiTabletPlan || plan instanceof CreateMultiTimeSeriesPlan || plan instanceof InsertRowsPlan ? this.forwardMultiSubPlan(planGroupMap, plan) : (planGroupMap.size() == 1 ? this.forwardToSingleGroup(planGroupMap.entrySet().iterator().next()) : this.forwardToMultipleGroup(planGroupMap));
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.isSetRedirectNode()) {
            status.setCode(TSStatusCode.NEED_REDIRECTION.getStatusCode());
        }
        logger.debug("{}: executed {} with answer {}", new Object[]{this.name, plan, status});
        return status;
    }

    private TSStatus forwardToSingleGroup(Map.Entry<PhysicalPlan, PartitionGroup> entry) {
        TSStatus result;
        if (entry.getValue().contains(this.thisNode)) {
            long startTime = Timer.Statistic.META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_LOCAL_GROUP.getOperationStartTime();
            result = this.metaGroupMember.getLocalDataMember(entry.getValue().getHeader()).executeNonQueryPlan(entry.getKey());
            logger.debug("Execute {} in a local group of {}, {}", new Object[]{entry.getKey(), entry.getValue().getHeader(), result});
            Timer.Statistic.META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_LOCAL_GROUP.calOperationCostTimeFromStart(startTime);
        } else {
            long startTime = Timer.Statistic.META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_REMOTE_GROUP.getOperationStartTime();
            logger.debug("Forward {} to a remote group of {}", (Object)entry.getKey(), (Object)entry.getValue().getHeader());
            result = this.forwardPlan(entry.getKey(), entry.getValue());
            Timer.Statistic.META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_REMOTE_GROUP.calOperationCostTimeFromStart(startTime);
        }
        return result;
    }

    private TSStatus forwardToMultipleGroup(Map<PhysicalPlan, PartitionGroup> planGroupMap) {
        ArrayList<String> errorCodePartitionGroups = new ArrayList<String>();
        boolean allRedirect = true;
        EndPoint endPoint = null;
        for (Map.Entry<PhysicalPlan, PartitionGroup> entry : planGroupMap.entrySet()) {
            TSStatus tmpStatus = this.forwardToSingleGroup(entry);
            if (tmpStatus.isSetRedirectNode()) {
                endPoint = tmpStatus.getRedirectNode();
            } else {
                allRedirect = false;
            }
            if (tmpStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            errorCodePartitionGroups.add(String.format("[%s@%s:%s]", tmpStatus.getCode(), entry.getValue().getHeader(), tmpStatus.getMessage()));
        }
        TSStatus status = errorCodePartitionGroups.isEmpty() ? (allRedirect ? StatusUtils.getStatus(TSStatusCode.NEED_REDIRECTION, endPoint) : StatusUtils.OK) : StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, MSG_MULTIPLE_ERROR + errorCodePartitionGroups);
        return status;
    }

    private TSStatus forwardMultiSubPlan(Map<PhysicalPlan, PartitionGroup> planGroupMap, PhysicalPlan parentPlan) {
        ArrayList<String> errorCodePartitionGroups = new ArrayList<String>();
        Object[] subStatus = null;
        boolean noFailure = true;
        boolean isBatchFailure = false;
        boolean isBatchRedirect = false;
        int totalRowNum = parentPlan.getPaths().size();
        for (Map.Entry<PhysicalPlan, PartitionGroup> entry : planGroupMap.entrySet()) {
            TSStatus tmpStatus = this.forwardToSingleGroup(entry);
            logger.debug("{}: from {},{},{}", new Object[]{this.name, entry.getKey(), entry.getValue(), tmpStatus});
            noFailure = tmpStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && noFailure;
            boolean bl = isBatchFailure = tmpStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode() || isBatchFailure;
            if (tmpStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode() || tmpStatus.isSetRedirectNode() && !(parentPlan instanceof CreateMultiTimeSeriesPlan)) {
                CreateMultiTimeSeriesPlan subPlan;
                if (parentPlan instanceof InsertMultiTabletPlan) {
                    totalRowNum = ((InsertMultiTabletPlan)parentPlan).getTabletsSize();
                } else if (parentPlan instanceof CreateMultiTimeSeriesPlan) {
                    totalRowNum = parentPlan.getPaths().size();
                } else if (parentPlan instanceof InsertRowsPlan) {
                    totalRowNum = ((InsertRowsPlan)parentPlan).getRowCount();
                }
                if (subStatus == null) {
                    subStatus = new TSStatus[totalRowNum];
                    Arrays.fill(subStatus, RpcUtils.SUCCESS_STATUS);
                }
                if (parentPlan instanceof InsertMultiTabletPlan) {
                    InsertMultiTabletPlan tmpMultiTabletPlan = (InsertMultiTabletPlan)entry.getKey();
                    for (int i = 0; i < tmpMultiTabletPlan.getInsertTabletPlanList().size(); ++i) {
                        InsertTabletPlan tmpInsertTabletPlan = tmpMultiTabletPlan.getInsertTabletPlan(i);
                        int parentIndex = tmpMultiTabletPlan.getParentIndex(i);
                        int parentPlanRowCount = ((InsertMultiTabletPlan)parentPlan).getRowCount(parentIndex);
                        if (tmpStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                            subStatus[parentIndex] = (TSStatus)tmpStatus.subStatus.get(i);
                            if (((TSStatus)tmpStatus.subStatus.get(i)).getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                                if (((TSStatus)subStatus[parentIndex]).subStatus == null) {
                                    Object[] tmpSubTsStatus = new TSStatus[parentPlanRowCount];
                                    Arrays.fill(tmpSubTsStatus, RpcUtils.SUCCESS_STATUS);
                                    ((TSStatus)subStatus[parentIndex]).subStatus = Arrays.asList(tmpSubTsStatus);
                                }
                                TSStatus[] reorderTsStatus = ((TSStatus)subStatus[parentIndex]).subStatus.toArray(new TSStatus[0]);
                                PartitionUtils.reordering(tmpInsertTabletPlan, reorderTsStatus, ((TSStatus)tmpStatus.subStatus.get((int)i)).subStatus.toArray(new TSStatus[0]));
                                ((TSStatus)subStatus[parentIndex]).subStatus = Arrays.asList(reorderTsStatus);
                            }
                            if (!tmpStatus.isSetRedirectNode() || !tmpStatus.isSetRedirectNode() || tmpInsertTabletPlan.getMaxTime() != ((InsertMultiTabletPlan)parentPlan).getInsertTabletPlan(parentIndex).getMaxTime()) continue;
                            subStatus[parentIndex].setRedirectNode(tmpStatus.redirectNode);
                            isBatchRedirect = true;
                            continue;
                        }
                        if (tmpStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() || !tmpStatus.isSetRedirectNode() || tmpInsertTabletPlan.getMaxTime() != ((InsertMultiTabletPlan)parentPlan).getInsertTabletPlan(parentIndex).getMaxTime()) continue;
                        subStatus[parentIndex] = StatusUtils.getStatus(RpcUtils.SUCCESS_STATUS, tmpStatus.redirectNode);
                        isBatchRedirect = true;
                    }
                } else if (parentPlan instanceof CreateMultiTimeSeriesPlan) {
                    subPlan = (CreateMultiTimeSeriesPlan)entry.getKey();
                    for (int i = 0; i < subPlan.getIndexes().size(); ++i) {
                        subStatus[((Integer)subPlan.getIndexes().get((int)i)).intValue()] = (TSStatus)tmpStatus.subStatus.get(i);
                    }
                } else if (parentPlan instanceof InsertRowsPlan) {
                    subPlan = (InsertRowsPlan)entry.getKey();
                    if (tmpStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                        for (int i = 0; i < subPlan.getInsertRowPlanIndexList().size(); ++i) {
                            subStatus[((Integer)subPlan.getInsertRowPlanIndexList().get((int)i)).intValue()] = (TSStatus)tmpStatus.subStatus.get(i);
                            if (!tmpStatus.isSetRedirectNode()) continue;
                            subStatus[(Integer)subPlan.getInsertRowPlanIndexList().get(i)].setRedirectNode(tmpStatus.getRedirectNode());
                            isBatchRedirect = true;
                        }
                    } else if (tmpStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && tmpStatus.isSetRedirectNode()) {
                        isBatchRedirect = true;
                        TSStatus redirectStatus = StatusUtils.getStatus(RpcUtils.SUCCESS_STATUS, tmpStatus.getRedirectNode());
                        for (int i = 0; i < subPlan.getInsertRowPlanIndexList().size(); ++i) {
                            subStatus[((Integer)subPlan.getInsertRowPlanIndexList().get((int)i)).intValue()] = redirectStatus;
                        }
                    }
                }
            }
            if (tmpStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            errorCodePartitionGroups.add(String.format("[%s@%s:%s:%s]", tmpStatus.getCode(), entry.getValue().getHeader(), tmpStatus.getMessage(), tmpStatus.subStatus));
        }
        return this.concludeFinalStatus(parentPlan, totalRowNum, noFailure, isBatchRedirect, isBatchFailure, (TSStatus[])subStatus, (List<String>)errorCodePartitionGroups);
    }

    private TSStatus concludeFinalStatus(PhysicalPlan parentPlan, int totalRowNum, boolean noFailure, boolean isBatchRedirect, boolean isBatchFailure, TSStatus[] subStatus, List<String> errorCodePartitionGroups) {
        TSStatus status;
        if (parentPlan instanceof InsertMultiTabletPlan && !((InsertMultiTabletPlan)parentPlan).getResults().isEmpty()) {
            if (subStatus == null) {
                subStatus = new TSStatus[totalRowNum];
                Arrays.fill(subStatus, RpcUtils.SUCCESS_STATUS);
            }
            noFailure = false;
            isBatchFailure = true;
            for (Map.Entry integerTSStatusEntry : ((InsertMultiTabletPlan)parentPlan).getResults().entrySet()) {
                subStatus[((Integer)integerTSStatusEntry.getKey()).intValue()] = (TSStatus)integerTSStatusEntry.getValue();
            }
        }
        if (parentPlan instanceof CreateMultiTimeSeriesPlan && !((CreateMultiTimeSeriesPlan)parentPlan).getResults().isEmpty()) {
            if (subStatus == null) {
                subStatus = new TSStatus[totalRowNum];
                Arrays.fill(subStatus, RpcUtils.SUCCESS_STATUS);
            }
            noFailure = false;
            isBatchFailure = true;
            for (Map.Entry integerTSStatusEntry : ((CreateMultiTimeSeriesPlan)parentPlan).getResults().entrySet()) {
                subStatus[((Integer)integerTSStatusEntry.getKey()).intValue()] = (TSStatus)integerTSStatusEntry.getValue();
            }
        }
        if (parentPlan instanceof InsertRowsPlan && !((InsertRowsPlan)parentPlan).getResults().isEmpty()) {
            if (subStatus == null) {
                subStatus = new TSStatus[totalRowNum];
                Arrays.fill(subStatus, RpcUtils.SUCCESS_STATUS);
            }
            noFailure = false;
            isBatchFailure = true;
            for (Map.Entry integerTSStatusEntry : ((InsertRowsPlan)parentPlan).getResults().entrySet()) {
                subStatus[((Integer)integerTSStatusEntry.getKey()).intValue()] = (TSStatus)integerTSStatusEntry.getValue();
            }
        }
        if (noFailure) {
            if (isBatchRedirect) {
                status = RpcUtils.getStatus(Arrays.asList(subStatus));
                status.setCode(TSStatusCode.NEED_REDIRECTION.getStatusCode());
            } else {
                status = StatusUtils.OK;
            }
        } else {
            status = isBatchFailure ? RpcUtils.getStatus(Arrays.asList(subStatus)) : StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, MSG_MULTIPLE_ERROR + errorCodePartitionGroups);
        }
        return status;
    }

    private TSStatus forwardPlan(PhysicalPlan plan, PartitionGroup group) {
        for (Node node : group) {
            TSStatus status;
            try {
                status = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.forwardDataPlanAsync(plan, node, group.getHeader()) : this.forwardDataPlanSync(plan, node, group.getHeader());
            }
            catch (IOException e) {
                status = StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, e.getMessage());
            }
            if (!StatusUtils.TIME_OUT.equals(status)) {
                if (!status.isSetRedirectNode()) {
                    status.setRedirectNode(new EndPoint(node.getClientIp(), node.getClientPort()));
                }
                return status;
            }
            logger.warn("Forward {} to {} timed out", (Object)plan, (Object)node);
        }
        logger.warn("Forward {} to {} timed out", (Object)plan, (Object)group);
        return StatusUtils.TIME_OUT;
    }

    private TSStatus forwardDataPlanAsync(PhysicalPlan plan, Node receiver, RaftNode header) throws IOException {
        AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(receiver, ClusterConstant.getWriteOperationTimeoutMS());
        return this.metaGroupMember.forwardPlanAsync(plan, receiver, header, (RaftService.AsyncClient)client);
    }

    private TSStatus forwardDataPlanSync(PhysicalPlan plan, Node receiver, RaftNode header) throws IOException {
        SyncDataClient client = ClusterIoTDB.getInstance().getSyncDataClient(receiver, ClusterConstant.getWriteOperationTimeoutMS());
        return this.metaGroupMember.forwardPlanSync(plan, receiver, header, (RaftService.Client)client);
    }

    public Node getThisNode() {
        return this.thisNode;
    }
}

