/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowTimeSeriesHandler
implements AsyncMethodCallback<List<ShowTimeSeriesResult>> {
    private static final Logger logger = LoggerFactory.getLogger(ShowTimeSeriesHandler.class);
    private final String path;
    private final CountDownLatch countDownLatch;
    private final long startTimeInMs;
    private final Map<String, ShowTimeSeriesResult> timeSeriesNameToResult = new HashMap<String, ShowTimeSeriesResult>();
    private final List<Exception> exceptions = new ArrayList<Exception>();

    public ShowTimeSeriesHandler(int numGroup, PartialPath path) {
        this.countDownLatch = new CountDownLatch(numGroup);
        this.path = path.toString();
        this.startTimeInMs = System.currentTimeMillis();
    }

    public synchronized void onComplete(List<ShowTimeSeriesResult> response) {
        for (ShowTimeSeriesResult r : response) {
            this.timeSeriesNameToResult.put(r.getName(), r);
        }
        this.countDownLatch.countDown();
        logger.debug("Got {} timeseries in path {}. Remaining count: {}", new Object[]{response.size(), this.path, this.countDownLatch.getCount()});
    }

    public synchronized void onError(Exception exception) {
        this.exceptions.add(exception);
        this.countDownLatch.countDown();
        logger.error("Failed to get timeseries in path {} because of {}", (Object)this.path, (Object)exception.getMessage());
    }

    public List<ShowTimeSeriesResult> getResult() throws MetadataException {
        if (!this.exceptions.isEmpty()) {
            MetadataException e = new MetadataException("Exception happened when getting the result. See the suppressed exceptions for causes.");
            for (Exception exception : this.exceptions) {
                e.addSuppressed((Throwable)exception);
            }
            throw e;
        }
        long timeout = IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold();
        while (System.currentTimeMillis() - this.startTimeInMs < timeout) {
            try {
                if (!this.countDownLatch.await(System.currentTimeMillis() - this.startTimeInMs, TimeUnit.MILLISECONDS)) continue;
                break;
            }
            catch (InterruptedException exception) {
            }
        }
        if (this.countDownLatch.getCount() != 0L) {
            String errMsg = String.format("Failed to get the show timeseries result since %d nodes didn't respond after %d ms", this.countDownLatch.getCount(), timeout);
            logger.error(errMsg);
            throw new MetadataException(errMsg);
        }
        return this.timeSeriesNameToResult.values().stream().sorted(Comparator.comparingLong(ShowTimeSeriesResult::getLastTime).reversed().thenComparing(ShowResult::getName)).collect(Collectors.toList());
    }
}

