/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.logtypes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;

public class AddNodeLog
extends Log {
    private ByteBuffer partitionTable;
    private Node newNode;
    private long metaLogIndex;

    public AddNodeLog(ByteBuffer partitionTable, Node newNode) {
        this.partitionTable = partitionTable;
        this.newNode = newNode;
    }

    public AddNodeLog() {
    }

    public long getMetaLogIndex() {
        return this.metaLogIndex;
    }

    public void setMetaLogIndex(long metaLogIndex) {
        this.metaLogIndex = metaLogIndex;
    }

    public void setPartitionTable(ByteBuffer partitionTable) {
        this.partitionTable = partitionTable;
    }

    public void setNewNode(Node newNode) {
        this.newNode = newNode;
    }

    public Node getNewNode() {
        return this.newNode;
    }

    public ByteBuffer getPartitionTable() {
        this.partitionTable.rewind();
        return this.partitionTable;
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeByte(Log.Types.ADD_NODE.ordinal());
            dataOutputStream.writeLong(this.getCurrLogIndex());
            dataOutputStream.writeLong(this.getCurrLogTerm());
            dataOutputStream.writeLong(this.getMetaLogIndex());
            NodeSerializeUtils.serialize(this.newNode, dataOutputStream);
            dataOutputStream.writeInt(this.partitionTable.array().length);
            dataOutputStream.write(this.partitionTable.array());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.setCurrLogIndex(buffer.getLong());
        this.setCurrLogTerm(buffer.getLong());
        this.setMetaLogIndex(buffer.getLong());
        this.newNode = new Node();
        NodeSerializeUtils.deserialize(this.newNode, buffer);
        int len = buffer.getInt();
        byte[] data = new byte[len];
        System.arraycopy(buffer.array(), buffer.position(), data, 0, len);
        this.partitionTable = ByteBuffer.wrap(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddNodeLog that = (AddNodeLog)o;
        return Objects.equals(this.newNode, that.newNode) && Objects.equals(this.partitionTable, that.partitionTable);
    }

    public String toString() {
        return "AddNodeLog{newNode=" + this.newNode.toString() + '}';
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.newNode, this.partitionTable);
    }
}

