/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HardLinkCleaner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HardLinkCleaner.class);
    private static final long HARDLINK_LIFE_MS = 259200000L;

    @Override
    public void run() {
        this.scanFolders(DirectoryManager.getInstance().getAllSequenceFileFolders());
        if (Thread.interrupted()) {
            return;
        }
        this.scanFolders(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
    }

    private void scanFolders(List<String> folders) {
        for (String folder : folders) {
            this.scanFolder(folder);
        }
    }

    private void scanFolder(String folder) {
        File folderFile = new File(folder);
        this.scanFile(folderFile);
    }

    private void scanFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File file1 : files) {
                    this.scanFile(file1);
                    if (!Thread.interrupted()) continue;
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            return;
        }
        long hardLinkCreateTime = this.getHardLinkCreateTime(file);
        long currentTime = System.currentTimeMillis();
        if (hardLinkCreateTime != -1L && currentTime - hardLinkCreateTime >= 259200000L) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.debug("Hardlink {} cannot be removed, leave it to the next try: {}", (Object)file, (Object)e.getMessage());
            }
        }
    }

    private long getHardLinkCreateTime(File file) {
        String fileName = file.getName();
        int suffixIndex = fileName.lastIndexOf(46);
        if (suffixIndex > 0 && suffixIndex < fileName.length()) {
            String suffix = fileName.substring(suffixIndex + 1);
            String[] split = suffix.split("_");
            if (split.length != 2) {
                return -1L;
            }
            try {
                return Long.parseLong(split[0]);
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }
}

