/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.exception.metadata;

import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.rpc.TSStatusCode;

public class StorageGroupAlreadySetException
extends MetadataException {
    private static final long serialVersionUID = 9110669164701929779L;
    private final boolean hasChild;
    private final String storageGroupPath;

    public StorageGroupAlreadySetException(String path) {
        super(StorageGroupAlreadySetException.getMessage(path, false), TSStatusCode.PATH_ALREADY_EXIST_ERROR.getStatusCode());
        this.storageGroupPath = path;
        this.hasChild = false;
    }

    public StorageGroupAlreadySetException(String path, boolean hasChild) {
        super(StorageGroupAlreadySetException.getMessage(path, hasChild), TSStatusCode.PATH_ALREADY_EXIST_ERROR.getStatusCode());
        this.hasChild = hasChild;
        this.storageGroupPath = path;
    }

    public boolean isHasChild() {
        return this.hasChild;
    }

    public String getStorageGroupPath() {
        return this.storageGroupPath;
    }

    private static String getMessage(String path, boolean hasChild) {
        if (hasChild) {
            return String.format("some children of %s have already been set to storage group", path);
        }
        return String.format("%s has already been set to storage group", path);
    }
}

