/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCreateDeviceMNodePlan
extends PhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(AutoCreateDeviceMNodePlan.class);
    protected PartialPath path;

    public AutoCreateDeviceMNodePlan() {
        super(Operator.OperatorType.AUTO_CREATE_DEVICE_MNODE);
    }

    public AutoCreateDeviceMNodePlan(PartialPath path) {
        super(Operator.OperatorType.AUTO_CREATE_DEVICE_MNODE);
        this.path = path;
    }

    public List<PartialPath> getPaths() {
        return Collections.singletonList(this.path);
    }

    public PartialPath getPath() {
        return this.path;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.AUTO_CREATE_DEVICE_MNODE.ordinal());
        this.putString(buffer, this.path.getFullPath());
        buffer.putLong(this.index);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.write((byte)PhysicalPlan.PhysicalPlanType.AUTO_CREATE_DEVICE_MNODE.ordinal());
        this.putString(stream, this.path.getFullPath());
        stream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        String pathString = this.readString(buffer);
        try {
            this.path = new PartialPath(pathString);
        }
        catch (IllegalPathException e) {
            logger.error("Failed to deserialize device {} from buffer", (Object)pathString);
        }
        this.index = buffer.getLong();
    }
}

