/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesReaderByTimestamp
implements IReaderByTimestamp {
    private final SeriesReader seriesReader;
    private BatchData batchData;
    private final boolean ascending;

    public SeriesReaderByTimestamp(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, TsFileFilter fileFilter, boolean ascending) {
        Filter timeFilter = TimeFilter.defaultTimeFilter((boolean)ascending);
        this.seriesReader = seriesPath.createSeriesReader(allSensors, dataType, context, dataSource, timeFilter, null, fileFilter, ascending);
        this.ascending = ascending;
    }

    public SeriesReaderByTimestamp(SeriesReader seriesReader, boolean ascending) {
        this.seriesReader = seriesReader;
        this.ascending = ascending;
    }

    public SeriesReaderByTimestamp(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, boolean ascending) {
        Filter timeFilter = TimeFilter.defaultTimeFilter((boolean)ascending);
        this.seriesReader = new SeriesReader(seriesPath, allSensors, dataType, context, seqFileResource, unseqFileResource, timeFilter, null, ascending);
        this.ascending = ascending;
    }

    @Override
    public Object[] getValuesInTimestamps(long[] timestamps, int length) throws IOException {
        if (length <= 0) {
            return null;
        }
        Object[] results = new Object[length];
        this.seriesReader.setTimeFilter(timestamps[0]);
        for (int i = 0; i < length && (this.batchData != null && this.hasAvailableData(this.batchData, timestamps[i]) || this.hasNext(timestamps[i])); ++i) {
            results[i] = this.batchData.getValueInTimestamp(timestamps[i]);
        }
        return results;
    }

    @Override
    public boolean readerIsEmpty() throws IOException {
        return this.seriesReader.isEmpty() && this.isEmpty(this.batchData);
    }

    protected boolean hasNext(long timestamp) throws IOException {
        if (this.readPageData(timestamp)) {
            return true;
        }
        if (this.readChunkData(timestamp)) {
            return true;
        }
        while (this.seriesReader.hasNextFile()) {
            Statistics statistics = this.seriesReader.currentFileStatistics();
            if (!this.satisfyTimeFilter(statistics)) {
                this.seriesReader.skipCurrentFile();
                continue;
            }
            if (!this.readChunkData(timestamp)) continue;
            return true;
        }
        return false;
    }

    private boolean readChunkData(long timestamp) throws IOException {
        while (this.seriesReader.hasNextChunk()) {
            Statistics statistics = this.seriesReader.currentChunkStatistics();
            if (!this.satisfyTimeFilter(statistics)) {
                this.seriesReader.skipCurrentChunk();
                continue;
            }
            if (!this.readPageData(timestamp)) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData(long timestamp) throws IOException {
        while (this.seriesReader.hasNextPage()) {
            if (!this.seriesReader.isPageOverlapped() && !this.satisfyTimeFilter(this.seriesReader.currentPageStatistics())) {
                this.seriesReader.skipCurrentPage();
                continue;
            }
            this.batchData = this.seriesReader.nextPage();
            if (this.isEmpty(this.batchData) || !this.hasAvailableData(this.batchData, timestamp)) continue;
            return true;
        }
        return false;
    }

    private boolean satisfyTimeFilter(Statistics statistics) {
        return this.seriesReader.getTimeFilter().satisfy(statistics);
    }

    private boolean isEmpty(BatchData batchData) {
        return batchData == null || !batchData.hasCurrent();
    }

    private boolean hasAvailableData(BatchData data, long time) {
        return this.ascending ? data.getMaxTimestamp() >= time : data.getMinTimestamp() <= time;
    }
}

