/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.IQueueRepository;
import io.moquette.broker.SessionRegistry;
import io.moquette.persistence.H2PersistentQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.h2.mvstore.MVStore;

public class H2QueueRepository
implements IQueueRepository {
    private MVStore mvStore;

    public H2QueueRepository(MVStore mvStore) {
        this.mvStore = mvStore;
    }

    @Override
    public Queue<SessionRegistry.EnqueuedMessage> createQueue(String cli, boolean clean) {
        if (!clean) {
            return new H2PersistentQueue<SessionRegistry.EnqueuedMessage>(this.mvStore, cli);
        }
        return new ConcurrentLinkedQueue<SessionRegistry.EnqueuedMessage>();
    }

    @Override
    public Map<String, Queue<SessionRegistry.EnqueuedMessage>> listAllQueues() {
        HashMap<String, Queue<SessionRegistry.EnqueuedMessage>> result = new HashMap<String, Queue<SessionRegistry.EnqueuedMessage>>();
        this.mvStore.getMapNames().stream().filter(name -> name.startsWith("queue_") && !name.endsWith("_meta")).map(name -> name.substring("queue_".length())).forEach(name -> result.put((String)name, new H2PersistentQueue(this.mvStore, (String)name)));
        return result;
    }
}

