<!--

​    Licensed to the Apache Software Foundation (ASF) under one
​    or more contributor license agreements.  See the NOTICE file
​    distributed with this work for additional information
​    regarding copyright ownership.  The ASF licenses this file
​    to you under the Apache License, Version 2.0 (the
​    "License"); you may not use this file except in compliance
​    with the License.  You may obtain a copy of the License at
​    
​        http://www.apache.org/licenses/LICENSE-2.0
​    
​    Unless required by applicable law or agreed to in writing,
​    software distributed under the License is distributed on an
​    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
​    KIND, either express or implied.  See the License for the
​    specific language governing permissions and limitations
​    under the License.

-->

# M4

## M4

### Usage

This function is used to execute the M4 aggregation query using the MAC (merging all chunks) approach.

**Name:** M4

**Input Series:** Only supports a single input sequence, the type is INT32 / INT64 / FLOAT / DOUBLE

**Parameters:**

+ `tqs`: The start time (included) of the query time range.
+ `tqe`: The end time (excluded) of the query time range.
+ `w`: The number of time spans in the M4 aggregation.

**Output Series:** The first, last, bottom, and top points in each time span
[tqs+(tqe-tqs)/w*(i-1),tqs+(tqe-tqs)/w*i), i=1,...,w.

**Note:**
+ This function is right now only supported in the branch `research/M4-visualization` right now.
+ You need to make sure (tqe-tqs) is divisible by w.
+ You need to add `time>=tqs and time<tqe` in the where clause.

### Examples

Input series:

```
+-----------------------------+------------------+
|                         Time|root.vehicle.d0.s0|
+-----------------------------+------------------+
|1970-01-01T08:00:00.001+08:00|               5.0|
|1970-01-01T08:00:00.002+08:00|              15.0|
|1970-01-01T08:00:00.005+08:00|              10.0|
|1970-01-01T08:00:00.008+08:00|               8.0|
|1970-01-01T08:00:00.010+08:00|              20.0|
|1970-01-01T08:00:00.020+08:00|              20.0|
|1970-01-01T08:00:00.025+08:00|               8.0|
|1970-01-01T08:00:00.027+08:00|              20.0|
|1970-01-01T08:00:00.030+08:00|              40.0|
|1970-01-01T08:00:00.033+08:00|               9.0|
|1970-01-01T08:00:00.035+08:00|              10.0|
|1970-01-01T08:00:00.040+08:00|              20.0|
|1970-01-01T08:00:00.045+08:00|              30.0|
|1970-01-01T08:00:00.052+08:00|               8.0|
|1970-01-01T08:00:00.054+08:00|              18.0|
|1970-01-01T08:00:00.120+08:00|               8.0|
+-----------------------------+------------------+
```

SQL for query:

```sql
select M4(s0,'tqs'='0','tqe'='100','w'='4') from root.vehicle.d0 where time>=0 and time<100
```

Output:

```
+-----------------------------+----------------------------------------------------------------------------------+
|                         Time|                           M4(root.vehicle.d0.s0, "tqs"="0", "tqe"="100", "w"="4")|
+-----------------------------+----------------------------------------------------------------------------------+
|1970-01-01T08:00:00.000+08:00|  FirstPoint=(1,5.0), LastPoint=(20,20.0), BottomPoint=(1,5.0), TopPoint=(10,20.0)|
|1970-01-01T08:00:00.025+08:00|FirstPoint=(25,8.0), LastPoint=(45,30.0), BottomPoint=(25,8.0), TopPoint=(30,40.0)|
|1970-01-01T08:00:00.050+08:00|FirstPoint=(52,8.0), LastPoint=(54,18.0), BottomPoint=(52,8.0), TopPoint=(54,18.0)|
|1970-01-01T08:00:00.075+08:00|                                                                             empty|
+-----------------------------+----------------------------------------------------------------------------------+
```