/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.writer.tsmiterator;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.reader.LocalTsFileInput;
import org.apache.tsfile.read.reader.TsFileInput;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.writer.tsmiterator.TSMIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskTSMIterator
extends TSMIterator {
    private static final Logger LOG = LoggerFactory.getLogger(DiskTSMIterator.class);
    private LinkedList<Long> endPosForEachDevice;
    protected TsFileInput input;
    private long fileLength = 0L;
    private long currentPos = 0L;
    private long nextEndPosForDevice = 0L;
    private String currentDevice;
    private boolean remainsInFile = true;

    protected DiskTSMIterator(File cmtFile, List<ChunkGroupMetadata> chunkGroupMetadataList, LinkedList<Long> endPosForEachDevice) throws IOException {
        super(chunkGroupMetadataList);
        this.endPosForEachDevice = endPosForEachDevice;
        this.input = new LocalTsFileInput(cmtFile.toPath());
        this.fileLength = cmtFile.length();
        this.nextEndPosForDevice = endPosForEachDevice.removeFirst();
    }

    @Override
    public boolean hasNext() {
        return this.remainsInFile || this.iterator.hasNext();
    }

    @Override
    public Pair<Path, TimeseriesMetadata> next() throws IOException {
        try {
            if (this.remainsInFile) {
                return this.getTimeSeriesMetadataFromFile();
            }
            return super.next();
        }
        catch (IOException e) {
            if (!Thread.currentThread().isInterrupted()) {
                LOG.error("Meets IOException when reading timeseries metadata from disk", (Throwable)e);
            }
            throw e;
        }
    }

    private Pair<Path, TimeseriesMetadata> getTimeSeriesMetadataFromFile() throws IOException {
        if (this.currentPos == this.nextEndPosForDevice) {
            this.currentDevice = ReadWriteIOUtils.readString(this.input.wrapAsInputStream());
            this.nextEndPosForDevice = this.endPosForEachDevice.size() > 0 ? this.endPosForEachDevice.removeFirst() : this.fileLength;
        }
        String measurementUid = ReadWriteIOUtils.readVarIntString(this.input.wrapAsInputStream());
        byte dataTypeInByte = ReadWriteIOUtils.readByte(this.input.wrapAsInputStream());
        TSDataType dataType = TSDataType.getTsDataType((byte)dataTypeInByte);
        int chunkBufferSize = ReadWriteIOUtils.readInt(this.input.wrapAsInputStream());
        ByteBuffer chunkBuffer = ByteBuffer.allocate(chunkBufferSize);
        int readSize = ReadWriteIOUtils.readAsPossible(this.input, chunkBuffer);
        if (readSize < chunkBufferSize) {
            throw new IOException(String.format("Expected to read %s bytes, but actually read %s bytes", chunkBufferSize, readSize));
        }
        chunkBuffer.flip();
        ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>();
        while (chunkBuffer.hasRemaining()) {
            chunkMetadataList.add(ChunkMetadata.deserializeFrom(chunkBuffer, dataType));
        }
        this.updateCurrentPos();
        return new Pair<Path, TimeseriesMetadata>(new Path(this.currentDevice, measurementUid, false), DiskTSMIterator.constructOneTimeseriesMetadata(measurementUid, chunkMetadataList));
    }

    private void updateCurrentPos() throws IOException {
        this.currentPos = this.input.position();
        if (this.currentPos >= this.fileLength) {
            this.remainsInFile = false;
            this.input.close();
        }
    }
}

