/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.subtask.sink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.config.constant.PipeSinkConstant;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskSinkRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeSinkSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeRealtimePriorityBlockingQueue;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtask;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtaskLifeCycle;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.db.pipe.sink.protocol.thrift.async.IoTDBDataRegionAsyncSink;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeSinkSubtaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSinkSubtaskManager.class);
    private static final String FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE = "Failed to deregister PipeConnectorSubtask. No such subtask: ";
    private final Map<String, List<PipeSinkSubtaskLifeCycle>> attributeSortedString2SubtaskLifeCycleMap = new HashMap<String, List<PipeSinkSubtaskLifeCycle>>();

    public synchronized String register(Supplier<? extends PipeSinkSubtaskExecutor> executorSupplier, PipeParameters pipeConnectorParameters, PipeTaskSinkRuntimeEnvironment environment) {
        int connectorNum;
        String connectorKey = pipeConnectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase();
        PipeEventCommitManager.getInstance().register(environment.getPipeName(), environment.getCreationTime(), environment.getRegionId(), connectorKey);
        boolean isDataRegionConnector = StorageEngine.getInstance().getAllDataRegionIds().contains(new DataRegionId(environment.getRegionId()));
        boolean realTimeFirst = false;
        String attributeSortedString = this.generateAttributeSortedString(pipeConnectorParameters);
        if (isDataRegionConnector) {
            connectorNum = pipeConnectorParameters.getIntOrDefault(Arrays.asList("connector.parallel.tasks", "sink.parallel.tasks"), PipeSinkConstant.CONNECTOR_IOTDB_PARALLEL_TASKS_DEFAULT_VALUE);
            realTimeFirst = pipeConnectorParameters.getBooleanOrDefault(Arrays.asList("connector.realtime-first", "sink.realtime-first"), true);
            attributeSortedString = "data_" + attributeSortedString;
        } else {
            connectorNum = 1;
            attributeSortedString = "schema_" + attributeSortedString;
        }
        environment.setAttributeSortedString(attributeSortedString);
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            PipeRealtimePriorityBlockingQueue pendingQueue;
            PipeSinkSubtaskExecutor executor = executorSupplier.get();
            ArrayList<PipeSinkSubtaskLifeCycle> pipeSinkSubtaskLifeCycleList = new ArrayList<PipeSinkSubtaskLifeCycle>(connectorNum);
            AtomicInteger counter = new AtomicInteger(0);
            PipeRealtimePriorityBlockingQueue pipeRealtimePriorityBlockingQueue = pendingQueue = realTimeFirst ? new PipeRealtimePriorityBlockingQueue() : new UnboundedBlockingPendingQueue((PipeEventCounter)new PipeDataRegionEventCounter());
            if (realTimeFirst) {
                pendingQueue.setOfferTsFileCounter(counter);
            }
            for (int connectorIndex = 0; connectorIndex < connectorNum; ++connectorIndex) {
                PipeConnector pipeConnector = isDataRegionConnector ? PipeDataNodeAgent.plugin().dataRegion().reflectConnector(pipeConnectorParameters) : PipeDataNodeAgent.plugin().schemaRegion().reflectConnector(pipeConnectorParameters);
                try {
                    if (pipeConnector instanceof IoTDBDataRegionAsyncSink) {
                        ((IoTDBDataRegionAsyncSink)pipeConnector).setTransferTsFileCounter(counter);
                    }
                    pipeConnector.validate(new PipeParameterValidator(pipeConnectorParameters));
                    pipeConnector.customize(pipeConnectorParameters, (PipeConnectorRuntimeConfiguration)new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)environment));
                    pipeConnector.handshake();
                }
                catch (Exception e) {
                    try {
                        pipeConnector.close();
                    }
                    catch (Exception closeException) {
                        LOGGER.warn("Failed to close connector after failed to initialize connector. Ignore this exception.", (Throwable)closeException);
                    }
                    throw new PipeException("Failed to construct PipeConnector, because of " + e.getMessage(), (Throwable)e);
                }
                PipeSinkSubtask pipeSinkSubtask = new PipeSinkSubtask(String.format("%s_%s_%s", attributeSortedString, environment.getCreationTime(), connectorIndex), environment.getCreationTime(), attributeSortedString, connectorIndex, pendingQueue, pipeConnector);
                PipeSinkSubtaskLifeCycle pipeSinkSubtaskLifeCycle = new PipeSinkSubtaskLifeCycle(executor, pipeSinkSubtask, pendingQueue);
                pipeSinkSubtaskLifeCycleList.add(pipeSinkSubtaskLifeCycle);
            }
            LOGGER.info("Pipe connector subtasks with attributes {} is bounded with connectorExecutor {} and callbackExecutor {}.", new Object[]{attributeSortedString, executor.getWorkingThreadName(), executor.getCallbackThreadName()});
            this.attributeSortedString2SubtaskLifeCycleMap.put(attributeSortedString, pipeSinkSubtaskLifeCycleList);
        }
        for (PipeSinkSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.register();
        }
        return attributeSortedString;
    }

    public synchronized void deregister(String pipeName, long creationTime, int regionId, String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        List<PipeSinkSubtaskLifeCycle> lifeCycles = this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString);
        PipeSinkSubtaskExecutor executor = lifeCycles.get((int)0).executor;
        lifeCycles.removeIf(o -> o.deregister(pipeName, regionId));
        if (lifeCycles.isEmpty()) {
            this.attributeSortedString2SubtaskLifeCycleMap.remove(attributeSortedString);
            executor.shutdown();
            LOGGER.info("The executor {} and {} has been successfully shutdown.", (Object)executor.getWorkingThreadName(), (Object)executor.getCallbackThreadName());
        }
        PipeEventCommitManager.getInstance().deregister(pipeName, creationTime, regionId);
    }

    public synchronized void start(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        for (PipeSinkSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.start();
        }
    }

    public synchronized void stop(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        for (PipeSinkSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.stop();
        }
    }

    public UnboundedBlockingPendingQueue<Event> getPipeConnectorPendingQueue(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException("Failed to get PendingQueue. No such subtask: " + attributeSortedString);
        }
        return this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).get(0).getPendingQueue();
    }

    private String generateAttributeSortedString(PipeParameters pipeConnectorParameters) {
        TreeMap sortedStringSourceMap = new TreeMap(pipeConnectorParameters.getAttribute());
        sortedStringSourceMap.remove("__system.restart_or_newly_added");
        return sortedStringSourceMap.toString();
    }

    private PipeSinkSubtaskManager() {
    }

    public static PipeSinkSubtaskManager instance() {
        return PipeSubtaskManagerHolder.INSTANCE;
    }

    private static class PipeSubtaskManagerHolder {
        private static final PipeSinkSubtaskManager INSTANCE = new PipeSinkSubtaskManager();

        private PipeSubtaskManagerHolder() {
        }
    }
}

