/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.DateType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.UnknownType;
import org.apache.tsfile.utils.Binary;

public final class LiteralEncoder {
    private final PlannerContext plannerContext;

    public LiteralEncoder(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    public List<Expression> toExpressions(List<?> objects, List<? extends Type> types) {
        Objects.requireNonNull(objects, "objects is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((objects.size() == types.size() ? 1 : 0) != 0, (Object)"objects and types do not have the same size");
        ImmutableList.Builder expressions = ImmutableList.builder();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            Type type = types.get(i);
            expressions.add((Object)this.toExpression(object, type));
        }
        return expressions.build();
    }

    public Expression toExpression(@Nullable Object object, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object == null) {
            if (type.equals(UnknownType.UNKNOWN)) {
                return new NullLiteral();
            }
            return new Cast(new NullLiteral(), TypeSignatureTranslator.toSqlType(type), false);
        }
        if (type.equals(IntType.INT32) || type.equals(LongType.INT64)) {
            return new LongLiteral(object.toString());
        }
        if (type.equals(FloatType.FLOAT) || type.equals(DoubleType.DOUBLE)) {
            Double value = (Double)object;
            return new DoubleLiteral(value);
        }
        if (TableMetadataImpl.isBool(type)) {
            return new BooleanLiteral(object.toString());
        }
        if (TableMetadataImpl.isCharType(type)) {
            Binary value = (Binary)object;
            return new StringLiteral(value.getStringValue(TSFileConfig.STRING_CHARSET));
        }
        if (TableMetadataImpl.isBlobType(type)) {
            Binary value = (Binary)object;
            return new BinaryLiteral(value.getValues());
        }
        if (type.equals(DateType.DATE)) {
            return new GenericLiteral(DateType.DATE.getTypeEnum().name(), ((Integer)object).toString());
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return new GenericLiteral(TimestampType.TIMESTAMP.getTypeEnum().name(), object.toString());
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }
}

