/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative;

import com.google.common.base.Preconditions;
import com.google.common.collect.MoreCollectors;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.GroupReference;

public interface Lookup {
    default public PlanNode resolve(PlanNode node) {
        if (node instanceof GroupReference) {
            return (PlanNode)((Optional)this.resolveGroup(node).collect(MoreCollectors.toOptional())).get();
        }
        return node;
    }

    public Stream<PlanNode> resolveGroup(PlanNode var1);

    public static Lookup noLookup() {
        return node -> {
            throw new UnsupportedOperationException();
        };
    }

    public static Lookup from(Function<GroupReference, Stream<PlanNode>> resolver) {
        return node -> {
            Preconditions.checkArgument((boolean)(node instanceof GroupReference), (String)"Node '%s' is not a GroupReference", (Object)node.getClass().getSimpleName());
            return (Stream)resolver.apply((GroupReference)node);
        };
    }
}

