/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.row;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.pipe.api.type.Type;
import org.apache.tsfile.enums.TSDataType;

public class PipeDataTypeTransformer {
    public static List<Type> transformToPipeDataTypeList(List<TSDataType> tsDataTypeList) {
        return tsDataTypeList == null ? null : tsDataTypeList.stream().map(PipeDataTypeTransformer::transformToPipeDataType).collect(Collectors.toList());
    }

    public static Type transformToPipeDataType(TSDataType tsDataType) {
        return tsDataType == null ? null : PipeDataTypeTransformer.getPipeDataType(tsDataType.getType());
    }

    private static Type getPipeDataType(byte type) {
        switch (type) {
            case 0: {
                return Type.BOOLEAN;
            }
            case 1: {
                return Type.INT32;
            }
            case 2: {
                return Type.INT64;
            }
            case 3: {
                return Type.FLOAT;
            }
            case 4: {
                return Type.DOUBLE;
            }
            case 5: {
                return Type.TEXT;
            }
            case 8: {
                return Type.TIMESTAMP;
            }
            case 9: {
                return Type.DATE;
            }
            case 10: {
                return Type.BLOB;
            }
            case 11: {
                return Type.STRING;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }

    private PipeDataTypeTransformer() {
    }
}

