/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.sink.protocol;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.sink.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.sink.client.IoTDBSyncClientManager;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.sink.protocol.IoTDBSslSyncSink;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionWritePlanEvent;
import org.apache.iotdb.confignode.manager.pipe.sink.client.IoTDBConfigNodeSyncClientManager;
import org.apache.iotdb.confignode.manager.pipe.sink.payload.PipeTransferConfigPlanReq;
import org.apache.iotdb.confignode.manager.pipe.sink.payload.PipeTransferConfigSnapshotPieceReq;
import org.apache.iotdb.confignode.manager.pipe.sink.payload.PipeTransferConfigSnapshotSealReq;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public class IoTDBConfigRegionSink
extends IoTDBSslSyncSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConfigRegionSink.class);

    protected IoTDBSyncClientManager constructClient(List<TEndPoint> nodeUrls, boolean useSSL, String trustStorePath, String trustStorePwd, boolean useLeaderCache, String loadBalanceStrategy, String username, String password, boolean shouldReceiverConvertOnTypeMismatch, String loadTsFileStrategy, boolean validateTsFile, boolean shouldMarkAsPipeRequest) {
        return new IoTDBConfigNodeSyncClientManager(nodeUrls, useSSL, Objects.nonNull(trustStorePath) ? ConfigNodeConfig.addHomeDir(trustStorePath) : null, trustStorePwd, loadBalanceStrategy, username, password, shouldReceiverConvertOnTypeMismatch, loadTsFileStrategy, validateTsFile, shouldMarkAsPipeRequest);
    }

    protected PipeTransferFilePieceReq getTransferSingleFilePieceReq(String fileName, long position, byte[] payLoad) {
        throw new UnsupportedOperationException("The config region connector does not support transferring single file piece req.");
    }

    protected PipeTransferFilePieceReq getTransferMultiFilePieceReq(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferConfigSnapshotPieceReq.toTPipeTransferReq(fileName, position, payLoad);
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBConfigRegionConnector can't transfer TabletInsertionEvent.");
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBConfigRegionConnector can't transfer TsFileInsertionEvent.");
    }

    public void transfer(Event event) throws Exception {
        if (event instanceof PipeConfigRegionWritePlanEvent) {
            this.doTransferWrapper((PipeConfigRegionWritePlanEvent)event);
        } else if (event instanceof PipeConfigRegionSnapshotEvent) {
            this.doTransferWrapper((PipeConfigRegionSnapshotEvent)event);
        } else if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("IoTDBConfigRegionConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    private void doTransferWrapper(PipeConfigRegionWritePlanEvent pipeConfigRegionWritePlanEvent) throws PipeException {
        if (!pipeConfigRegionWritePlanEvent.increaseReferenceCount(IoTDBConfigRegionSink.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeConfigRegionWritePlanEvent);
        }
        finally {
            pipeConfigRegionWritePlanEvent.decreaseReferenceCount(IoTDBConfigRegionSink.class.getName(), false);
        }
    }

    private void doTransfer(PipeConfigRegionWritePlanEvent pipeConfigRegionWritePlanEvent) throws PipeException {
        TPipeTransferResp resp;
        Pair clientAndStatus = this.getClientManager().getClient();
        try {
            TPipeTransferReq req = this.compressIfNeeded(PipeTransferConfigPlanReq.toTPipeTransferReq(pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan()));
            this.rateLimitIfNeeded(pipeConfigRegionWritePlanEvent.getPipeName(), pipeConfigRegionWritePlanEvent.getCreationTime(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), req.getBody().length);
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer config region write plan %s, because %s.", new Object[]{pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan().getType(), e.getMessage()}), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() == TSStatusCode.PIPE_CONFIG_RECEIVER_HANDSHAKE_NEEDED.getStatusCode()) {
            this.getClientManager().sendHandshakeReq(clientAndStatus);
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Transfer config region write plan %s error, result status %s.", new Object[]{pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan().getType(), status}), pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan().toString());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully transferred config event {}.", (Object)pipeConfigRegionWritePlanEvent);
        }
    }

    private void doTransferWrapper(PipeConfigRegionSnapshotEvent pipeConfigRegionSnapshotEvent) throws PipeException, IOException {
        if (!pipeConfigRegionSnapshotEvent.increaseReferenceCount(IoTDBConfigRegionSink.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeConfigRegionSnapshotEvent);
        }
        finally {
            pipeConfigRegionSnapshotEvent.decreaseReferenceCount(IoTDBConfigRegionSink.class.getName(), false);
        }
    }

    private void doTransfer(PipeConfigRegionSnapshotEvent snapshotEvent) throws PipeException, IOException {
        TPipeTransferResp resp;
        String pipeName = snapshotEvent.getPipeName();
        long creationTime = snapshotEvent.getCreationTime();
        File snapshotFile = snapshotEvent.getSnapshotFile();
        File templateFile = snapshotEvent.getTemplateFile();
        Pair clientAndStatus = this.getClientManager().getClient();
        this.transferFilePieces(Collections.singletonMap(new Pair((Object)pipeName, (Object)creationTime), 1.0), snapshotFile, clientAndStatus, true);
        if (Objects.nonNull(templateFile)) {
            this.transferFilePieces(Collections.singletonMap(new Pair((Object)pipeName, (Object)creationTime), 1.0), templateFile, clientAndStatus, true);
        }
        try {
            TPipeTransferReq req = this.compressIfNeeded((TPipeTransferReq)PipeTransferConfigSnapshotSealReq.toTPipeTransferReq(snapshotEvent.getTreePattern().getPattern(), snapshotEvent.getTablePattern().getDatabasePattern(), snapshotEvent.getTablePattern().getTablePattern(), snapshotEvent.getTreePattern().isTreeModelDataAllowedToBeCaptured(), snapshotEvent.getTablePattern().isTableModelDataAllowedToBeCaptured(), snapshotFile.getName(), snapshotFile.length(), Objects.nonNull(templateFile) ? templateFile.getName() : null, Objects.nonNull(templateFile) ? templateFile.length() : 0L, snapshotEvent.getFileType(), snapshotEvent.toSealTypeString()));
            this.rateLimitIfNeeded(snapshotEvent.getPipeName(), snapshotEvent.getCreationTime(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), req.getBody().length);
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when seal config region snapshot %s, because %s.", snapshotFile, e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() == TSStatusCode.PIPE_CONFIG_RECEIVER_HANDSHAKE_NEEDED.getStatusCode()) {
            this.getClientManager().sendHandshakeReq(clientAndStatus);
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Seal config region snapshot file %s error, result status %s.", snapshotFile, resp.getStatus()), snapshotFile.toString());
        }
        LOGGER.info("Successfully transferred config region snapshot {}.", (Object)snapshotFile);
    }
}

