/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.FieldId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.tsfile.read.common.type.Type;

@Immutable
public class ResolvedField {
    private final Scope scope;
    private final Field field;
    private final int hierarchyFieldIndex;
    private final int relationFieldIndex;
    private final boolean local;

    public ResolvedField(Scope scope, Field field, int hierarchyFieldIndex, int relationFieldIndex, boolean local) {
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.field = Objects.requireNonNull(field, "field is null");
        this.hierarchyFieldIndex = hierarchyFieldIndex;
        this.relationFieldIndex = relationFieldIndex;
        this.local = local;
    }

    public FieldId getFieldId() {
        return FieldId.from(this);
    }

    public Type getType() {
        return this.field.getType();
    }

    public TsTableColumnCategory getColumnCategory() {
        return this.field.getColumnCategory();
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getHierarchyFieldIndex() {
        return this.hierarchyFieldIndex;
    }

    public int getRelationFieldIndex() {
        return this.relationFieldIndex;
    }

    public Field getField() {
        return this.field;
    }
}

