/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionLastTimeCheckFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.AlignedSeriesBatchCompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactionAlignedPageLazyLoadPointReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.ChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.InstantChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.InstantPageLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.PageLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class ReadChunkAlignedSeriesCompactionExecutor {
    protected final IDeviceID device;
    protected final LinkedList<Pair<TsFileSequenceReader, List<AbstractAlignedChunkMetadata>>> readerAndChunkMetadataList;
    protected final TsFileResource targetResource;
    protected final CompactionTsFileWriter writer;
    protected AlignedChunkWriterImpl chunkWriter;
    protected IMeasurementSchema timeSchema;
    protected List<IMeasurementSchema> schemaList;
    protected ReadChunkAlignedSeriesCompactionFlushController flushController;
    protected final CompactionTaskSummary summary;
    protected final boolean ignoreAllNullRows;
    private long lastWriteTimestamp;
    private boolean lastWriteTimestampSet = false;

    public ReadChunkAlignedSeriesCompactionExecutor(IDeviceID device, TsFileResource targetResource, LinkedList<Pair<TsFileSequenceReader, List<AbstractAlignedChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter writer, CompactionTaskSummary summary, boolean ignoreAllNullRows) throws IOException {
        this.device = device;
        this.readerAndChunkMetadataList = readerAndChunkMetadataList;
        this.writer = writer;
        this.targetResource = targetResource;
        this.summary = summary;
        this.collectValueColumnSchemaList();
        this.fillAlignedChunkMetadataToMatchSchemaList();
        int compactionFileLevel = Integer.parseInt(this.targetResource.getTsFile().getName().split("-")[2]);
        this.flushController = new ReadChunkAlignedSeriesCompactionFlushController(compactionFileLevel);
        this.chunkWriter = this.constructAlignedChunkWriter();
        this.ignoreAllNullRows = ignoreAllNullRows;
    }

    public ReadChunkAlignedSeriesCompactionExecutor(IDeviceID device, TsFileResource targetResource, LinkedList<Pair<TsFileSequenceReader, List<AbstractAlignedChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter writer, CompactionTaskSummary summary, IMeasurementSchema timeSchema, List<IMeasurementSchema> valueSchemaList, boolean ignoreAllNullRows) {
        this.device = device;
        this.readerAndChunkMetadataList = readerAndChunkMetadataList;
        this.writer = writer;
        this.targetResource = targetResource;
        this.summary = summary;
        int compactionFileLevel = Integer.parseInt(this.targetResource.getTsFile().getName().split("-")[2]);
        this.flushController = new ReadChunkAlignedSeriesCompactionFlushController(compactionFileLevel);
        this.timeSchema = timeSchema;
        this.schemaList = valueSchemaList;
        this.chunkWriter = this.constructAlignedChunkWriter();
        this.ignoreAllNullRows = ignoreAllNullRows;
    }

    private void collectValueColumnSchemaList() throws IOException {
        HashMap<String, MeasurementSchema> measurementSchemaMap = new HashMap<String, MeasurementSchema>();
        for (int i = this.readerAndChunkMetadataList.size() - 1; i >= 0; --i) {
            Pair<TsFileSequenceReader, List<AbstractAlignedChunkMetadata>> pair = this.readerAndChunkMetadataList.get(i);
            CompactionTsFileReader reader = (CompactionTsFileReader)((Object)pair.getLeft());
            List alignedChunkMetadataList = (List)pair.getRight();
            for (AbstractAlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
                if (alignedChunkMetadata == null) continue;
                if (this.timeSchema == null) {
                    ChunkMetadata timeChunkMetadata = (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata();
                    ChunkHeader timeChunkHeader = reader.readChunkHeader(timeChunkMetadata.getOffsetOfChunkHeader());
                    this.timeSchema = new MeasurementSchema(timeChunkHeader.getMeasurementID(), timeChunkHeader.getDataType(), timeChunkHeader.getEncodingType(), timeChunkHeader.getCompressionType());
                }
                for (IChunkMetadata chunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                    if (chunkMetadata == null || measurementSchemaMap.containsKey(chunkMetadata.getMeasurementUid())) continue;
                    ChunkHeader chunkHeader = reader.readChunkHeader(chunkMetadata.getOffsetOfChunkHeader());
                    MeasurementSchema schema = new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
                    measurementSchemaMap.put(chunkMetadata.getMeasurementUid(), schema);
                }
            }
        }
        this.schemaList = measurementSchemaMap.values().stream().sorted(Comparator.comparing(IMeasurementSchema::getMeasurementName)).collect(Collectors.toList());
    }

    private void fillAlignedChunkMetadataToMatchSchemaList() {
        for (Pair pair : this.readerAndChunkMetadataList) {
            List alignedChunkMetadataList = (List)pair.getRight();
            for (int i = 0; i < alignedChunkMetadataList.size(); ++i) {
                AbstractAlignedChunkMetadata alignedChunkMetadata = (AbstractAlignedChunkMetadata)alignedChunkMetadataList.get(i);
                alignedChunkMetadataList.set(i, AlignedSeriesBatchCompactionUtils.fillAlignedChunkMetadataBySchemaList(alignedChunkMetadata, this.schemaList));
            }
        }
    }

    protected AlignedChunkWriterImpl constructAlignedChunkWriter() {
        return new AlignedChunkWriterImpl(this.timeSchema, this.schemaList);
    }

    public void execute() throws IOException, PageException {
        for (Pair pair : this.readerAndChunkMetadataList) {
            TsFileSequenceReader reader = (TsFileSequenceReader)pair.left;
            List alignedChunkMetadataList = (List)pair.right;
            if (reader instanceof CompactionTsFileReader) {
                ((CompactionTsFileReader)reader).markStartOfAlignedSeries();
            }
            for (AbstractAlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
                this.compactWithAlignedChunk(reader, alignedChunkMetadata);
            }
            if (!(reader instanceof CompactionTsFileReader)) continue;
            ((CompactionTsFileReader)reader).markEndOfAlignedSeries();
        }
        if (!this.chunkWriter.isEmpty()) {
            this.flushCurrentChunkWriter();
        }
    }

    private void compactWithAlignedChunk(TsFileSequenceReader reader, AbstractAlignedChunkMetadata alignedChunkMetadata) throws IOException, PageException {
        ChunkLoader timeChunk = this.getChunkLoader(reader, (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata());
        ArrayList<ChunkLoader> valueChunks = new ArrayList<ChunkLoader>(this.schemaList.size());
        long pointNum = 0L;
        for (int i = 0; i < alignedChunkMetadata.getValueChunkMetadataList().size(); ++i) {
            IChunkMetadata chunkMetadata = (IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(i);
            if (chunkMetadata == null || !chunkMetadata.getDataType().equals((Object)this.schemaList.get(i).getType())) {
                valueChunks.add(this.getChunkLoader(reader, null));
                continue;
            }
            pointNum += (long)chunkMetadata.getStatistics().getCount();
            valueChunks.add(this.getChunkLoader(reader, (ChunkMetadata)chunkMetadata));
        }
        this.summary.increaseProcessPointNum(pointNum);
        if (this.flushController.canFlushCurrentChunkWriter()) {
            this.flushCurrentChunkWriter();
        }
        if (this.flushController.canCompactCurrentChunkByDirectlyFlush(timeChunk, valueChunks)) {
            this.compactAlignedChunkByFlush(timeChunk, valueChunks);
        } else {
            this.compactAlignedChunkByDeserialize(timeChunk, valueChunks);
        }
    }

    protected ChunkLoader getChunkLoader(TsFileSequenceReader reader, ChunkMetadata chunkMetadata) throws IOException {
        if (chunkMetadata == null || chunkMetadata.getStatistics().getCount() == 0) {
            return new InstantChunkLoader();
        }
        Chunk chunk = reader.readMemChunk(chunkMetadata);
        return new InstantChunkLoader(reader.getFileName(), chunkMetadata, chunk);
    }

    protected void flushCurrentChunkWriter() throws IOException {
        this.chunkWriter.sealCurrentPage();
        this.writer.writeChunk((IChunkWriter)this.chunkWriter);
    }

    protected void compactAlignedChunkByFlush(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
        this.writer.markStartingWritingAligned();
        this.checkAndUpdatePreviousTimestamp(timeChunk.getChunkMetadata().getStartTime());
        if (timeChunk.getChunkMetadata().getStartTime() != timeChunk.getChunkMetadata().getEndTime()) {
            this.checkAndUpdatePreviousTimestamp(timeChunk.getChunkMetadata().getEndTime());
        }
        this.writer.writeChunk(timeChunk.getChunk(), timeChunk.getChunkMetadata());
        timeChunk.clear();
        int nonEmptyChunkNum = 1;
        for (int i = 0; i < valueChunks.size(); ++i) {
            ChunkLoader valueChunk = valueChunks.get(i);
            if (valueChunk.isEmpty()) {
                IMeasurementSchema schema = this.schemaList.get(i);
                this.writer.writeEmptyValueChunk(schema.getMeasurementName(), schema.getCompressor(), schema.getType(), schema.getEncodingType(), (Statistics<? extends Serializable>)Statistics.getStatsByType((TSDataType)schema.getType()));
                continue;
            }
            ++nonEmptyChunkNum;
            this.writer.writeChunk(valueChunk.getChunk(), valueChunk.getChunkMetadata());
            valueChunk.clear();
        }
        this.summary.increaseDirectlyFlushChunkNum(nonEmptyChunkNum);
        this.writer.markEndingWritingAligned();
    }

    private void compactAlignedChunkByDeserialize(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws PageException, IOException {
        List<PageLoader> timeColumnPageList = timeChunk.getPages();
        ArrayList<List<PageLoader>> pageListOfAllValueColumns = new ArrayList<List<PageLoader>>(valueChunks.size());
        int nonEmptyChunkNum = 1;
        for (ChunkLoader valueChunk : valueChunks) {
            if (!valueChunk.isEmpty()) {
                ++nonEmptyChunkNum;
            }
            List<PageLoader> valueColumnPageList = valueChunk.getPages();
            pageListOfAllValueColumns.add(valueColumnPageList);
            valueChunk.clear();
        }
        this.summary.increaseDeserializedChunkNum(nonEmptyChunkNum);
        for (int i = 0; i < timeColumnPageList.size(); ++i) {
            PageLoader timePage = timeColumnPageList.get(i);
            ArrayList<PageLoader> valuePages = new ArrayList<PageLoader>(valueChunks.size());
            for (List list : pageListOfAllValueColumns) {
                valuePages.add(list.isEmpty() ? this.getEmptyPage() : (PageLoader)list.get(i));
            }
            if (this.ignoreAllNullRows && this.isAllValuePageEmpty(timePage, valuePages) || !this.ignoreAllNullRows && timePage.isEmpty()) continue;
            if (this.flushController.canFlushCurrentChunkWriter()) {
                this.flushCurrentChunkWriter();
            }
            if (this.flushController.canCompactCurrentPageByDirectlyFlush(timePage, valuePages)) {
                this.chunkWriter.sealCurrentPage();
                this.compactAlignedPageByFlush(timePage, valuePages);
                continue;
            }
            this.compactAlignedPageByDeserialize(timePage, valuePages);
        }
    }

    protected boolean isAllValuePageEmpty(PageLoader timePage, List<PageLoader> valuePages) {
        for (PageLoader valuePage : valuePages) {
            if (valuePage.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private PageLoader getEmptyPage() {
        return new InstantPageLoader();
    }

    protected void compactAlignedPageByFlush(PageLoader timePage, List<PageLoader> valuePageLoaders) throws PageException, IOException {
        int nonEmptyPage = 1;
        this.checkAndUpdatePreviousTimestamp(timePage.getHeader().getStartTime());
        if (timePage.getHeader().getStartTime() != timePage.getHeader().getEndTime()) {
            this.checkAndUpdatePreviousTimestamp(timePage.getHeader().getEndTime());
        }
        timePage.flushToTimeChunkWriter(this.chunkWriter);
        for (int i = 0; i < valuePageLoaders.size(); ++i) {
            PageLoader valuePage = valuePageLoaders.get(i);
            if (!valuePage.isEmpty()) {
                ++nonEmptyPage;
            }
            valuePage.flushToValueChunkWriter(this.chunkWriter, i);
        }
        this.summary.increaseDirectlyFlushPageNum(nonEmptyPage);
    }

    private void compactAlignedPageByDeserialize(PageLoader timePage, List<PageLoader> valuePages) throws IOException {
        PageHeader timePageHeader = timePage.getHeader();
        ByteBuffer uncompressedTimePageData = timePage.getUnCompressedData();
        Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)timePage.getEncoding(), (TSDataType)TSDataType.INT64);
        TimePageReader timePageReader = new TimePageReader(timePageHeader, uncompressedTimePageData, timeDecoder);
        timePageReader.setDeleteIntervalList(timePage.getDeleteIntervalList());
        timePage.clear();
        ArrayList<ValuePageReader> valuePageReaders = new ArrayList<ValuePageReader>(valuePages.size());
        int nonEmptyPageNum = 1;
        for (int i = 0; i < valuePages.size(); ++i) {
            PageLoader valuePage = valuePages.get(i);
            ValuePageReader valuePageReader = null;
            if (!valuePage.isEmpty()) {
                valuePageReader = new ValuePageReader(valuePage.getHeader(), valuePage.getUnCompressedData(), valuePage.getDataType(), Decoder.getDecoderByType((TSEncoding)valuePage.getEncoding(), (TSDataType)valuePage.getDataType()));
                valuePageReader.setDeleteIntervalList(valuePage.getDeleteIntervalList());
                ++nonEmptyPageNum;
            }
            valuePage.clear();
            valuePageReaders.add(valuePageReader);
        }
        this.summary.increaseDeserializedPageNum(nonEmptyPageNum);
        long processedPointNum = 0L;
        IPointReader lazyPointReader = this.getPointReader(timePageReader, valuePageReaders);
        while (lazyPointReader.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = lazyPointReader.nextTimeValuePair();
            long currentTime = timeValuePair.getTimestamp();
            this.chunkWriter.write(currentTime, timeValuePair.getValue().getVector());
            this.checkAndUpdatePreviousTimestamp(currentTime);
            ++processedPointNum;
        }
        this.summary.increaseRewritePointNum(processedPointNum *= (long)this.schemaList.size());
        if (this.flushController.canFlushCurrentChunkWriter()) {
            this.flushCurrentChunkWriter();
        }
    }

    protected IPointReader getPointReader(TimePageReader timePageReader, List<ValuePageReader> valuePageReaders) throws IOException {
        return new CompactionAlignedPageLazyLoadPointReader(timePageReader, valuePageReaders, this.ignoreAllNullRows);
    }

    protected void checkAndUpdatePreviousTimestamp(long currentWritingTimestamp) {
        if (this.lastWriteTimestampSet && currentWritingTimestamp <= this.lastWriteTimestamp) {
            throw new CompactionLastTimeCheckFailedException(this.device.toString(), currentWritingTimestamp, this.lastWriteTimestamp);
        }
        this.lastWriteTimestamp = currentWritingTimestamp;
        this.lastWriteTimestampSet = true;
    }

    protected class ReadChunkAlignedSeriesCompactionFlushController {
        private static final int largeFileLevelSeparator = 2;
        private final int compactionTargetFileLevel;
        private final long targetChunkPointNum;
        private final long targetChunkSize;
        private final long targetPagePointNum;
        private final long targetPageSize;

        public ReadChunkAlignedSeriesCompactionFlushController(int compactionFileLevel) {
            this.compactionTargetFileLevel = compactionFileLevel;
            this.targetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
            this.targetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
            this.targetPageSize = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
            this.targetPagePointNum = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        }

        public boolean canCompactCurrentChunkByDirectlyFlush(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
            return this.canFlushCurrentChunkWriter() && this.canFlushChunk(timeChunk, valueChunks);
        }

        protected boolean canFlushCurrentChunkWriter() {
            return ReadChunkAlignedSeriesCompactionExecutor.this.chunkWriter.checkIsChunkSizeOverThreshold(this.targetChunkSize, this.targetChunkPointNum, true);
        }

        private boolean canFlushChunk(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
            boolean largeEnough;
            if (timeChunk.getModifiedStatus() == ModifiedStatus.PARTIAL_DELETED) {
                return false;
            }
            boolean bl = largeEnough = (long)timeChunk.getHeader().getDataSize() >= this.targetChunkSize || timeChunk.getChunkMetadata().getNumOfPoints() >= this.targetChunkPointNum;
            if (ReadChunkAlignedSeriesCompactionExecutor.this.timeSchema.getEncodingType() != timeChunk.getHeader().getEncodingType() || ReadChunkAlignedSeriesCompactionExecutor.this.timeSchema.getCompressor() != timeChunk.getHeader().getCompressionType()) {
                return false;
            }
            for (int i = 0; i < valueChunks.size(); ++i) {
                ChunkLoader valueChunk = valueChunks.get(i);
                if (valueChunk.isEmpty()) continue;
                IMeasurementSchema schema = ReadChunkAlignedSeriesCompactionExecutor.this.schemaList.get(i);
                if (schema.getEncodingType() != valueChunk.getHeader().getEncodingType() || schema.getCompressor() != valueChunk.getHeader().getCompressionType()) {
                    return false;
                }
                if (valueChunk.getModifiedStatus() == ModifiedStatus.PARTIAL_DELETED) {
                    return false;
                }
                if ((long)valueChunk.getHeader().getDataSize() < this.targetChunkSize) continue;
                largeEnough = true;
            }
            return largeEnough;
        }

        protected boolean canCompactCurrentPageByDirectlyFlush(PageLoader timePage, List<PageLoader> valuePages) {
            boolean isHighLevelCompaction;
            boolean bl = isHighLevelCompaction = this.compactionTargetFileLevel > 2;
            if (isHighLevelCompaction) {
                return this.canFlushPage(timePage, valuePages);
            }
            return this.canSealCurrentPageWriter() && this.canFlushPage(timePage, valuePages);
        }

        private boolean canSealCurrentPageWriter() {
            return ReadChunkAlignedSeriesCompactionExecutor.this.chunkWriter.checkIsUnsealedPageOverThreshold(this.targetPageSize, this.targetPagePointNum, true);
        }

        private boolean canFlushPage(PageLoader timePage, List<PageLoader> valuePages) {
            boolean largeEnough;
            if (timePage.getModifiedStatus() == ModifiedStatus.PARTIAL_DELETED) {
                return false;
            }
            long count = timePage.getHeader().getStatistics().getCount();
            boolean bl = largeEnough = count >= this.targetPagePointNum || Math.max(this.estimateMemorySizeAsPageWriter(timePage), (long)timePage.getHeader().getUncompressedSize()) >= this.targetPageSize;
            if (ReadChunkAlignedSeriesCompactionExecutor.this.timeSchema.getEncodingType() != timePage.getEncoding() || ReadChunkAlignedSeriesCompactionExecutor.this.timeSchema.getCompressor() != timePage.getCompressionType()) {
                return false;
            }
            for (int i = 0; i < valuePages.size(); ++i) {
                PageLoader valuePage = valuePages.get(i);
                if (valuePage.isEmpty()) continue;
                IMeasurementSchema schema = ReadChunkAlignedSeriesCompactionExecutor.this.schemaList.get(i);
                if (schema.getCompressor() != valuePage.getCompressionType() || schema.getEncodingType() != valuePage.getEncoding()) {
                    return false;
                }
                if (valuePage.getModifiedStatus() == ModifiedStatus.PARTIAL_DELETED) {
                    return false;
                }
                if (Math.max((long)valuePage.getHeader().getUncompressedSize(), this.estimateMemorySizeAsPageWriter(valuePage)) < this.targetPageSize) continue;
                largeEnough = true;
            }
            return largeEnough;
        }

        private long estimateMemorySizeAsPageWriter(PageLoader pageLoader) {
            long size;
            long count = pageLoader.getHeader().getStatistics().getCount();
            switch (pageLoader.getDataType()) {
                case INT32: 
                case DATE: {
                    size = count * 4L;
                    break;
                }
                case TIMESTAMP: 
                case INT64: 
                case VECTOR: {
                    size = count * 8L;
                    break;
                }
                case FLOAT: {
                    size = count * 4L;
                    break;
                }
                case DOUBLE: {
                    size = count * 8L;
                    break;
                }
                case BOOLEAN: {
                    size = count * 1L;
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    size = pageLoader.getHeader().getUncompressedSize();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type: " + pageLoader.getDataType().toString());
                }
            }
            return (long)((double)size * 1.05);
        }
    }
}

