/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class TranslateBrowsePathsToNodeIdsResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=555");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=557");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=556");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15194");
    private final ResponseHeader responseHeader;
    private final BrowsePathResult[] results;
    private final DiagnosticInfo[] diagnosticInfos;

    public TranslateBrowsePathsToNodeIdsResponse(ResponseHeader responseHeader, BrowsePathResult[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public BrowsePathResult[] getResults() {
        return this.results;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected TranslateBrowsePathsToNodeIdsResponse(TranslateBrowsePathsToNodeIdsResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((TranslateBrowsePathsToNodeIdsResponseBuilder)b).responseHeader;
        this.results = ((TranslateBrowsePathsToNodeIdsResponseBuilder)b).results;
        this.diagnosticInfos = ((TranslateBrowsePathsToNodeIdsResponseBuilder)b).diagnosticInfos;
    }

    public static TranslateBrowsePathsToNodeIdsResponseBuilder<?, ?> builder() {
        return new TranslateBrowsePathsToNodeIdsResponseBuilderImpl();
    }

    public TranslateBrowsePathsToNodeIdsResponseBuilder<?, ?> toBuilder() {
        return new TranslateBrowsePathsToNodeIdsResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslateBrowsePathsToNodeIdsResponse)) {
            return false;
        }
        TranslateBrowsePathsToNodeIdsResponse other = (TranslateBrowsePathsToNodeIdsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResults(), other.getResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslateBrowsePathsToNodeIdsResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "TranslateBrowsePathsToNodeIdsResponse(responseHeader=" + this.getResponseHeader() + ", results=" + Arrays.deepToString(this.getResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class TranslateBrowsePathsToNodeIdsResponseBuilderImpl
    extends TranslateBrowsePathsToNodeIdsResponseBuilder<TranslateBrowsePathsToNodeIdsResponse, TranslateBrowsePathsToNodeIdsResponseBuilderImpl> {
        private TranslateBrowsePathsToNodeIdsResponseBuilderImpl() {
        }

        @Override
        protected TranslateBrowsePathsToNodeIdsResponseBuilderImpl self() {
            return this;
        }

        @Override
        public TranslateBrowsePathsToNodeIdsResponse build() {
            return new TranslateBrowsePathsToNodeIdsResponse(this);
        }
    }

    public static abstract class TranslateBrowsePathsToNodeIdsResponseBuilder<C extends TranslateBrowsePathsToNodeIdsResponse, B extends TranslateBrowsePathsToNodeIdsResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private BrowsePathResult[] results;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TranslateBrowsePathsToNodeIdsResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TranslateBrowsePathsToNodeIdsResponse instance, TranslateBrowsePathsToNodeIdsResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.results(instance.results);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B results(BrowsePathResult[] results) {
            this.results = results;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TranslateBrowsePathsToNodeIdsResponse.TranslateBrowsePathsToNodeIdsResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", results=" + Arrays.deepToString(this.results) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<TranslateBrowsePathsToNodeIdsResponse> {
        @Override
        public Class<TranslateBrowsePathsToNodeIdsResponse> getType() {
            return TranslateBrowsePathsToNodeIdsResponse.class;
        }

        @Override
        public TranslateBrowsePathsToNodeIdsResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            BrowsePathResult[] results = (BrowsePathResult[])decoder.readStructArray("Results", BrowsePathResult.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new TranslateBrowsePathsToNodeIdsResponse(responseHeader, results, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TranslateBrowsePathsToNodeIdsResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("Results", (Object[])value.getResults(), BrowsePathResult.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

