/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public abstract class PatternQuantifier
extends Node {
    private final boolean greedy;

    protected PatternQuantifier(NodeLocation location, boolean greedy) {
        super(location);
        this.greedy = greedy;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPatternQuantifier(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PatternQuantifier o = (PatternQuantifier)obj;
        return this.greedy == o.greedy;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.greedy);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!PatternQuantifier.sameClass(this, other)) {
            return false;
        }
        PatternQuantifier otherNode = (PatternQuantifier)other;
        return this.greedy == otherNode.greedy;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("greedy", this.greedy).toString();
    }
}

