/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeAlterEncodingCompressorPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeTSStatusTaskExecutor;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteTimeSeriesProcedure;
import org.apache.iotdb.confignode.procedure.state.AlterEncodingCompressorState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.mpp.rpc.thrift.TAlterEncodingCompressorReq;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterEncodingCompressorProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, AlterEncodingCompressorState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlterEncodingCompressorState.class);
    private String queryId;
    private PathPatternTree patternTree;
    private boolean ifExists;
    private byte encoding;
    private byte compressor;
    private boolean mayAlterAudit = false;
    private transient ByteBuffer patternTreeBytes;
    private transient String requestMessage;

    public AlterEncodingCompressorProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public AlterEncodingCompressorProcedure(boolean isGeneratedByPipe, String queryId, PathPatternTree pathPatternTree, boolean ifExists, byte encoding, byte compressor, boolean mayAlterAudit) {
        super(isGeneratedByPipe);
        this.queryId = queryId;
        this.setPatternTree(pathPatternTree);
        this.ifExists = ifExists;
        this.encoding = encoding;
        this.compressor = compressor;
        this.mayAlterAudit = mayAlterAudit;
    }

    public String getQueryId() {
        return this.queryId;
    }

    @TestOnly
    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public void setPatternTree(PathPatternTree patternTree) {
        this.patternTree = patternTree;
        this.requestMessage = patternTree.getAllPathPatterns().toString();
        this.patternTreeBytes = DeleteTimeSeriesProcedure.preparePatternTreeBytesData(patternTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, AlterEncodingCompressorState state) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case ALTER_SCHEMA_REGION: {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Alter encoding {} & compressor {} in schema region for timeSeries {}", new Object[]{SerializeUtils.deserializeEncodingNullable((byte)this.encoding), SerializeUtils.deserializeCompressorNullable((byte)this.compressor), this.requestMessage});
                    }
                    if (this.alterEncodingCompressorInSchemaRegion(env)) break;
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                case CLEAR_CACHE: {
                    LOGGER.info("Invalidate cache of timeSeries {}", (Object)this.requestMessage);
                    DeleteTimeSeriesProcedure.invalidateCache(env, this.patternTreeBytes, this.requestMessage, x$0 -> this.setFailure((ProcedureException)x$0), false);
                    this.collectPayload4Pipe(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                default: {
                    this.setFailure(new ProcedureException("Unrecognized state " + (Object)((Object)state)));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("AlterEncodingCompressor-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private boolean alterEncodingCompressorInSchemaRegion(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree);
        if (relatedSchemaRegionGroup.isEmpty()) {
            if (!this.ifExists) {
                this.setFailure(new ProcedureException((Throwable)new PathNotExistException(this.patternTree.getAllPathPatterns().stream().map(PartialPath::getFullPath).collect(Collectors.toList()), false)));
            }
            return false;
        }
        DataNodeTSStatusTaskExecutor<TAlterEncodingCompressorReq> alterEncodingCompressorTask = new DataNodeTSStatusTaskExecutor<TAlterEncodingCompressorReq>(env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree), false, CnToDnAsyncRequestType.ALTER_ENCODING_COMPRESSOR, (dataNodeLocation, consensusGroupIdList) -> new TAlterEncodingCompressorReq(consensusGroupIdList, this.patternTreeBytes, this.ifExists).setCompressor(this.compressor).setEncoding(this.encoding)){
            private final Map<TDataNodeLocation, TSStatus> failureMap;
            {
                this.failureMap = new HashMap<TDataNodeLocation, TSStatus>();
            }

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    this.failureMap.remove(dataNodeLocation);
                    return failedRegionList;
                }
                if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatus = response.getSubStatus();
                    for (int i = 0; i < subStatus.size(); ++i) {
                        if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || ((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.PATH_NOT_EXIST.getStatusCode() && AlterEncodingCompressorProcedure.this.ifExists) continue;
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else if (response.getCode() != TSStatusCode.PATH_NOT_EXIST.getStatusCode() || !AlterEncodingCompressorProcedure.this.ifExists) {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                if (!failedRegionList.isEmpty()) {
                    this.failureMap.put(dataNodeLocation, response);
                } else {
                    this.failureMap.remove(dataNodeLocation);
                }
                return failedRegionList;
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
                AlterEncodingCompressorProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Alter encoding compressor %s in schema regions failed. Failures: %s", AlterEncodingCompressorProcedure.this.requestMessage, this.failureMap))));
                this.interruptTask();
            }
        };
        alterEncodingCompressorTask.execute();
        this.setNextState(AlterEncodingCompressorState.CLEAR_CACHE);
        return true;
    }

    private void collectPayload4Pipe(ConfigNodeProcedureEnv env) {
        TSStatus result;
        try {
            result = env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(new PipeAlterEncodingCompressorPlan(this.patternTreeBytes, this.encoding, this.compressor, false)) : new PipeAlterEncodingCompressorPlan(this.patternTreeBytes, this.encoding, this.compressor, false));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
        }
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(result.getMessage());
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, AlterEncodingCompressorState alterEncodingCompressorState) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected AlterEncodingCompressorState getState(int stateId) {
        return AlterEncodingCompressorState.values()[stateId];
    }

    @Override
    protected int getStateId(AlterEncodingCompressorState alterEncodingCompressorState) {
        return alterEncodingCompressorState.ordinal();
    }

    @Override
    protected AlterEncodingCompressorState getInitialState() {
        return AlterEncodingCompressorState.ALTER_SCHEMA_REGION;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_ALTER_ENCODING_COMPRESSOR_PROCEDURE.getTypeCode() : ProcedureType.ALTER_ENCODING_COMPRESSOR_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        this.patternTree.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.ifExists, (OutputStream)stream);
        ReadWriteIOUtils.write((byte)this.encoding, (OutputStream)stream);
        ReadWriteIOUtils.write((byte)this.compressor, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.setPatternTree(PathPatternTree.deserialize((ByteBuffer)byteBuffer));
        this.ifExists = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        this.encoding = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        this.compressor = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        this.mayAlterAudit = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterEncodingCompressorProcedure that = (AlterEncodingCompressorProcedure)o;
        return this.getProcId() == that.getProcId() && ((AlterEncodingCompressorState)((Object)this.getCurrentState())).equals(that.getCurrentState()) && this.getCycles() == this.getCycles() && Objects.equals(this.queryId, that.queryId) && this.isGeneratedByPipe == that.isGeneratedByPipe && this.patternTree.equals((Object)that.patternTree) && this.encoding == that.encoding && this.compressor == that.compressor && this.mayAlterAudit == that.mayAlterAudit;
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.queryId, this.isGeneratedByPipe, this.patternTree, this.ifExists, this.encoding, this.compressor, this.mayAlterAudit);
    }
}

