/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AscendingRangeIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.RangeIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;

public class DescendingRangeIterator
extends RangeIterator
implements AtomicIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator {
    long start;
    long step;
    long currentValue;
    long limit;

    public DescendingRangeIterator(long start, long step, long end) {
        assert (step > 0L);
        assert (start - end <= Integer.MAX_VALUE);
        this.start = start;
        this.step = step;
        this.currentValue = start + step;
        this.limit = end;
        if (step != 1L) {
            this.limit = start + (end - start) / step * step;
        }
    }

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }

    @Override
    public GroundedValue materialize() {
        return new IntegerRange(this.start, -this.step, this.limit);
    }

    @Override
    public GroundedValue getResidue() {
        return new IntegerRange(this.currentValue, -this.step, this.limit);
    }

    @Override
    public IntegerValue getFirst() {
        return new Int64Value(this.start);
    }

    @Override
    public IntegerValue getLast() {
        return new Int64Value(this.limit);
    }

    @Override
    public IntegerValue getMin() {
        return new Int64Value(this.limit);
    }

    @Override
    public IntegerValue getMax() {
        return new Int64Value(this.start);
    }

    @Override
    public IntegerValue getStep() {
        return new Int64Value(-this.step);
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue - this.step >= this.limit;
    }

    @Override
    public IntegerValue next() {
        this.currentValue -= this.step;
        if (this.currentValue < this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        return (int)(this.start - this.limit + 1L);
    }

    @Override
    public AtomicIterator getReverseIterator() {
        return new AscendingRangeIterator(this.start, this.step, this.limit);
    }
}

