/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text.action;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;

public class SelectLineAction
extends TextAction {
    private final Action start = new BeginLineAction("darklaf", false);
    private final Action end = new EndLineAction("darklaf", true);

    public SelectLineAction() {
        super("select-line");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.start.actionPerformed(e);
        this.end.actionPerformed(e);
    }

    public static class BeginLineAction
    extends TextAction {
        private final Segment currentLine = new Segment();
        private final boolean select;

        public BeginLineAction(String name, boolean select) {
            super(name);
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int newPos;
                JTextComponent textArea = this.getTextComponent(e);
                int caretPosition = textArea.getCaretPosition();
                Document document = textArea.getDocument();
                Element map = document.getDefaultRootElement();
                int currentLineNum = map.getElementIndex(caretPosition);
                Element currentLineElement = map.getElement(currentLineNum);
                int currentLineStart = currentLineElement.getStartOffset();
                int currentLineEnd = currentLineElement.getEndOffset();
                int count = currentLineEnd - currentLineStart;
                if (count > 0) {
                    document.getText(currentLineStart, count, this.currentLine);
                    int firstNonWhitespace = this.getFirstNonWhitespacePos();
                    firstNonWhitespace = currentLineStart + (firstNonWhitespace - this.currentLine.offset);
                    newPos = caretPosition != firstNonWhitespace ? firstNonWhitespace : currentLineStart;
                } else {
                    newPos = currentLineStart;
                }
                if (this.select) {
                    textArea.moveCaretPosition(newPos);
                } else {
                    textArea.setCaretPosition(newPos);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        private int getFirstNonWhitespacePos() {
            int offset = this.currentLine.offset;
            int end = offset + this.currentLine.count - 1;
            int pos = offset;
            char[] array = this.currentLine.array;
            char currentChar = array[pos];
            while ((currentChar == '\t' || currentChar == ' ') && ++pos < end) {
                currentChar = array[pos];
            }
            return pos;
        }
    }

    public static class EndLineAction
    extends TextAction {
        private final boolean select;

        public EndLineAction(String name, boolean select) {
            super(name);
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textArea = this.getTextComponent(e);
            int offs = textArea.getCaretPosition();
            try {
                Element root = textArea.getDocument().getDefaultRootElement();
                int line = root.getElementIndex(offs);
                int endOffs = root.getElement(line).getEndOffset() - 1;
                if (this.select) {
                    textArea.moveCaretPosition(endOffs);
                } else {
                    textArea.setCaretPosition(endOffs);
                }
            }
            catch (Exception ex) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
            }
        }
    }
}

